/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.IgnoredActivityCategories;
import com.mypurecloud.sdk.v2.model.IgnoredActivityCodeIds;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class AdherenceSettings
implements Serializable {
    private Integer severeAlertThresholdMinutes = null;
    private Integer adherenceTargetPercent = null;
    private Integer adherenceExceptionThresholdSeconds = null;
    private Boolean nonOnQueueActivitiesEquivalent = null;
    private Boolean trackOnQueueActivity = null;
    private IgnoredActivityCategories ignoredActivityCategories = null;
    private IgnoredActivityCodeIds ignoredActivityCodeIds = null;

    public AdherenceSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AdherenceSettings severeAlertThresholdMinutes(Integer severeAlertThresholdMinutes) {
        this.severeAlertThresholdMinutes = severeAlertThresholdMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The threshold in minutes where an alert will be triggered when an agent is considered severely out of adherence")
    @JsonProperty(value="severeAlertThresholdMinutes")
    public Integer getSevereAlertThresholdMinutes() {
        return this.severeAlertThresholdMinutes;
    }

    public void setSevereAlertThresholdMinutes(Integer severeAlertThresholdMinutes) {
        this.severeAlertThresholdMinutes = severeAlertThresholdMinutes;
    }

    public AdherenceSettings adherenceTargetPercent(Integer adherenceTargetPercent) {
        this.adherenceTargetPercent = adherenceTargetPercent;
        return this;
    }

    @ApiModelProperty(example="null", value="Target adherence percentage")
    @JsonProperty(value="adherenceTargetPercent")
    public Integer getAdherenceTargetPercent() {
        return this.adherenceTargetPercent;
    }

    public void setAdherenceTargetPercent(Integer adherenceTargetPercent) {
        this.adherenceTargetPercent = adherenceTargetPercent;
    }

    public AdherenceSettings adherenceExceptionThresholdSeconds(Integer adherenceExceptionThresholdSeconds) {
        this.adherenceExceptionThresholdSeconds = adherenceExceptionThresholdSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The threshold in seconds for which agents should not be penalized for being momentarily out of adherence")
    @JsonProperty(value="adherenceExceptionThresholdSeconds")
    public Integer getAdherenceExceptionThresholdSeconds() {
        return this.adherenceExceptionThresholdSeconds;
    }

    public void setAdherenceExceptionThresholdSeconds(Integer adherenceExceptionThresholdSeconds) {
        this.adherenceExceptionThresholdSeconds = adherenceExceptionThresholdSeconds;
    }

    public AdherenceSettings nonOnQueueActivitiesEquivalent(Boolean nonOnQueueActivitiesEquivalent) {
        this.nonOnQueueActivitiesEquivalent = nonOnQueueActivitiesEquivalent;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to treat all non-on-queue activities as equivalent for adherence purposes")
    @JsonProperty(value="nonOnQueueActivitiesEquivalent")
    public Boolean getNonOnQueueActivitiesEquivalent() {
        return this.nonOnQueueActivitiesEquivalent;
    }

    public void setNonOnQueueActivitiesEquivalent(Boolean nonOnQueueActivitiesEquivalent) {
        this.nonOnQueueActivitiesEquivalent = nonOnQueueActivitiesEquivalent;
    }

    public AdherenceSettings trackOnQueueActivity(Boolean trackOnQueueActivity) {
        this.trackOnQueueActivity = trackOnQueueActivity;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to track on-queue activities")
    @JsonProperty(value="trackOnQueueActivity")
    public Boolean getTrackOnQueueActivity() {
        return this.trackOnQueueActivity;
    }

    public void setTrackOnQueueActivity(Boolean trackOnQueueActivity) {
        this.trackOnQueueActivity = trackOnQueueActivity;
    }

    public AdherenceSettings ignoredActivityCategories(IgnoredActivityCategories ignoredActivityCategories) {
        this.ignoredActivityCategories = ignoredActivityCategories;
        return this;
    }

    @ApiModelProperty(example="null", value="Activity categories that should be ignored for adherence purposes")
    @JsonProperty(value="ignoredActivityCategories")
    public IgnoredActivityCategories getIgnoredActivityCategories() {
        return this.ignoredActivityCategories;
    }

    public void setIgnoredActivityCategories(IgnoredActivityCategories ignoredActivityCategories) {
        this.ignoredActivityCategories = ignoredActivityCategories;
    }

    public AdherenceSettings ignoredActivityCodeIds(IgnoredActivityCodeIds ignoredActivityCodeIds) {
        this.ignoredActivityCodeIds = ignoredActivityCodeIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Activity code IDs that should be ignored for adherence purposes")
    @JsonProperty(value="ignoredActivityCodeIds")
    public IgnoredActivityCodeIds getIgnoredActivityCodeIds() {
        return this.ignoredActivityCodeIds;
    }

    public void setIgnoredActivityCodeIds(IgnoredActivityCodeIds ignoredActivityCodeIds) {
        this.ignoredActivityCodeIds = ignoredActivityCodeIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdherenceSettings adherenceSettings = (AdherenceSettings)o;
        return Objects.equals(this.severeAlertThresholdMinutes, adherenceSettings.severeAlertThresholdMinutes) && Objects.equals(this.adherenceTargetPercent, adherenceSettings.adherenceTargetPercent) && Objects.equals(this.adherenceExceptionThresholdSeconds, adherenceSettings.adherenceExceptionThresholdSeconds) && Objects.equals(this.nonOnQueueActivitiesEquivalent, adherenceSettings.nonOnQueueActivitiesEquivalent) && Objects.equals(this.trackOnQueueActivity, adherenceSettings.trackOnQueueActivity) && Objects.equals(this.ignoredActivityCategories, adherenceSettings.ignoredActivityCategories) && Objects.equals(this.ignoredActivityCodeIds, adherenceSettings.ignoredActivityCodeIds);
    }

    public int hashCode() {
        return Objects.hash(this.severeAlertThresholdMinutes, this.adherenceTargetPercent, this.adherenceExceptionThresholdSeconds, this.nonOnQueueActivitiesEquivalent, this.trackOnQueueActivity, this.ignoredActivityCategories, this.ignoredActivityCodeIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdherenceSettings {\n");
        sb.append("    severeAlertThresholdMinutes: ").append(this.toIndentedString(this.severeAlertThresholdMinutes)).append("\n");
        sb.append("    adherenceTargetPercent: ").append(this.toIndentedString(this.adherenceTargetPercent)).append("\n");
        sb.append("    adherenceExceptionThresholdSeconds: ").append(this.toIndentedString(this.adherenceExceptionThresholdSeconds)).append("\n");
        sb.append("    nonOnQueueActivitiesEquivalent: ").append(this.toIndentedString(this.nonOnQueueActivitiesEquivalent)).append("\n");
        sb.append("    trackOnQueueActivity: ").append(this.toIndentedString(this.trackOnQueueActivity)).append("\n");
        sb.append("    ignoredActivityCategories: ").append(this.toIndentedString(this.ignoredActivityCategories)).append("\n");
        sb.append("    ignoredActivityCodeIds: ").append(this.toIndentedString(this.ignoredActivityCodeIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

