/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ActivationTrigger
implements Serializable {
    private TriggerTypeEnum triggerType = null;
    private Date triggerDate = null;
    private String intentId = null;
    private String intentName = null;

    public ActivationTrigger() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ActivationTrigger triggerType(TriggerTypeEnum triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    @ApiModelProperty(example="null", value="Trigger type that activated this checklist.")
    @JsonProperty(value="triggerType")
    public TriggerTypeEnum getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TriggerTypeEnum triggerType) {
        this.triggerType = triggerType;
    }

    public ActivationTrigger triggerDate(Date triggerDate) {
        this.triggerDate = triggerDate;
        return this;
    }

    @ApiModelProperty(example="2025-08-06T03:52:10.150Z", value="Date when the checklist was triggered. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="triggerDate")
    public Date getTriggerDate() {
        return this.triggerDate;
    }

    public void setTriggerDate(Date triggerDate) {
        this.triggerDate = triggerDate;
    }

    public ActivationTrigger intentId(String intentId) {
        this.intentId = intentId;
        return this;
    }

    @ApiModelProperty(example="null", value="The intent ID if checklist was triggered by an intent.")
    @JsonProperty(value="intentId")
    public String getIntentId() {
        return this.intentId;
    }

    public void setIntentId(String intentId) {
        this.intentId = intentId;
    }

    public ActivationTrigger intentName(String intentName) {
        this.intentName = intentName;
        return this;
    }

    @ApiModelProperty(example="null", value="The intent name if checklist was triggered by an intent.")
    @JsonProperty(value="intentName")
    public String getIntentName() {
        return this.intentName;
    }

    public void setIntentName(String intentName) {
        this.intentName = intentName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivationTrigger activationTrigger = (ActivationTrigger)o;
        return Objects.equals((Object)this.triggerType, (Object)activationTrigger.triggerType) && Objects.equals(this.triggerDate, activationTrigger.triggerDate) && Objects.equals(this.intentId, activationTrigger.intentId) && Objects.equals(this.intentName, activationTrigger.intentName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.triggerType, this.triggerDate, this.intentId, this.intentName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivationTrigger {\n");
        sb.append("    triggerType: ").append(this.toIndentedString((Object)this.triggerType)).append("\n");
        sb.append("    triggerDate: ").append(this.toIndentedString(this.triggerDate)).append("\n");
        sb.append("    intentId: ").append(this.toIndentedString(this.intentId)).append("\n");
        sb.append("    intentName: ").append(this.toIndentedString(this.intentName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TriggerTypeEnumDeserializer.class)
    public static enum TriggerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INTENT("Intent"),
        CONVERSATIONSTART("ConversationStart");

        private String value;

        private TriggerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TriggerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TriggerTypeEnum value : TriggerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TriggerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TriggerTypeEnumDeserializer
    extends StdDeserializer<TriggerTypeEnum> {
        public TriggerTypeEnumDeserializer() {
            super(TriggerTypeEnumDeserializer.class);
        }

        public TriggerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TriggerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

