/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.GrammarFileUploadRequest;
import java.util.HashMap;
import java.util.Map;

public class PostArchitectGrammarLanguageFilesDtmfRequest {
    private String grammarId;
    private String languageCode;
    private GrammarFileUploadRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGrammarId() {
        return this.grammarId;
    }

    public void setGrammarId(String grammarId) {
        this.grammarId = grammarId;
    }

    public PostArchitectGrammarLanguageFilesDtmfRequest withGrammarId(String grammarId) {
        this.setGrammarId(grammarId);
        return this;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public PostArchitectGrammarLanguageFilesDtmfRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public GrammarFileUploadRequest getBody() {
        return this.body;
    }

    public void setBody(GrammarFileUploadRequest body) {
        this.body = body;
    }

    public PostArchitectGrammarLanguageFilesDtmfRequest withBody(GrammarFileUploadRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostArchitectGrammarLanguageFilesDtmfRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<GrammarFileUploadRequest> withHttpInfo() {
        if (this.grammarId == null) {
            throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for PostArchitectGrammarLanguageFilesDtmfRequest.");
        }
        if (this.languageCode == null) {
            throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for PostArchitectGrammarLanguageFilesDtmfRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostArchitectGrammarLanguageFilesDtmfRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/architect/grammars/{grammarId}/languages/{languageCode}/files/dtmf").withPathParameter("grammarId", this.grammarId).withPathParameter("languageCode", this.languageCode).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String grammarId, String languageCode, GrammarFileUploadRequest body) {
        return new Builder().withRequiredParams(grammarId, languageCode, body);
    }

    public static class Builder {
        private final PostArchitectGrammarLanguageFilesDtmfRequest request = new PostArchitectGrammarLanguageFilesDtmfRequest();

        private Builder() {
        }

        public Builder withGrammarId(String grammarId) {
            this.request.setGrammarId(grammarId);
            return this;
        }

        public Builder withLanguageCode(String languageCode) {
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public Builder withBody(GrammarFileUploadRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String grammarId, String languageCode, GrammarFileUploadRequest body) {
            this.request.setGrammarId(grammarId);
            this.request.setLanguageCode(languageCode);
            this.request.setBody(body);
            return this;
        }

        public PostArchitectGrammarLanguageFilesDtmfRequest build() {
            if (this.request.grammarId == null) {
                throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for PostArchitectGrammarLanguageFilesDtmfRequest.");
            }
            if (this.request.languageCode == null) {
                throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for PostArchitectGrammarLanguageFilesDtmfRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostArchitectGrammarLanguageFilesDtmfRequest.");
            }
            return this.request;
        }
    }
}

