/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CampaignPatchRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchOutboundCampaignRequest {
    private String campaignId;
    private CampaignPatchRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public PatchOutboundCampaignRequest withCampaignId(String campaignId) {
        this.setCampaignId(campaignId);
        return this;
    }

    public CampaignPatchRequest getBody() {
        return this.body;
    }

    public void setBody(CampaignPatchRequest body) {
        this.body = body;
    }

    public PatchOutboundCampaignRequest withBody(CampaignPatchRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchOutboundCampaignRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CampaignPatchRequest> withHttpInfo() {
        if (this.campaignId == null) {
            throw new IllegalStateException("Missing the required parameter 'campaignId' when building request for PatchOutboundCampaignRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchOutboundCampaignRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/outbound/campaigns/{campaignId}").withPathParameter("campaignId", this.campaignId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String campaignId, CampaignPatchRequest body) {
        return new Builder().withRequiredParams(campaignId, body);
    }

    public static class Builder {
        private final PatchOutboundCampaignRequest request = new PatchOutboundCampaignRequest();

        private Builder() {
        }

        public Builder withCampaignId(String campaignId) {
            this.request.setCampaignId(campaignId);
            return this;
        }

        public Builder withBody(CampaignPatchRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String campaignId, CampaignPatchRequest body) {
            this.request.setCampaignId(campaignId);
            this.request.setBody(body);
            return this;
        }

        public PatchOutboundCampaignRequest build() {
            if (this.request.campaignId == null) {
                throw new IllegalStateException("Missing the required parameter 'campaignId' when building request for PatchOutboundCampaignRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchOutboundCampaignRequest.");
            }
            return this.request;
        }
    }
}

