/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetUsersRulesSettingRequest {
    private String ruleType;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    public GetUsersRulesSettingRequest withRuleType(String ruleType) {
        this.setRuleType(ruleType);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUsersRulesSettingRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.ruleType == null) {
            throw new IllegalStateException("Missing the required parameter 'ruleType' when building request for GetUsersRulesSettingRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/rules/settings/{ruleType}").withPathParameter("ruleType", this.ruleType).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String ruleType) {
        return new Builder().withRequiredParams(ruleType);
    }

    public static class Builder {
        private final GetUsersRulesSettingRequest request = new GetUsersRulesSettingRequest();

        private Builder() {
        }

        public Builder withRuleType(String ruleType) {
            this.request.setRuleType(ruleType);
            return this;
        }

        public Builder withRuleType(ruleTypeValues ruleType) {
            this.request.setRuleType(ruleType.toString());
            return this;
        }

        public Builder withRequiredParams(String ruleType) {
            this.request.setRuleType(ruleType);
            return this;
        }

        public GetUsersRulesSettingRequest build() {
            if (this.request.ruleType == null) {
                throw new IllegalStateException("Missing the required parameter 'ruleType' when building request for GetUsersRulesSettingRequest.");
            }
            return this.request;
        }
    }

    public static enum ruleTypeValues {
        LEARNING("Learning");

        private String value;

        private ruleTypeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ruleTypeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ruleTypeValues value : ruleTypeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ruleTypeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

