/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetUsersRuleDependentTypeIdRequest {
    private String ruleId;
    private String ruleType;
    private String typeId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public GetUsersRuleDependentTypeIdRequest withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public String getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    public GetUsersRuleDependentTypeIdRequest withRuleType(String ruleType) {
        this.setRuleType(ruleType);
        return this;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public GetUsersRuleDependentTypeIdRequest withTypeId(String typeId) {
        this.setTypeId(typeId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUsersRuleDependentTypeIdRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.ruleId == null) {
            throw new IllegalStateException("Missing the required parameter 'ruleId' when building request for GetUsersRuleDependentTypeIdRequest.");
        }
        if (this.ruleType == null) {
            throw new IllegalStateException("Missing the required parameter 'ruleType' when building request for GetUsersRuleDependentTypeIdRequest.");
        }
        if (this.typeId == null) {
            throw new IllegalStateException("Missing the required parameter 'typeId' when building request for GetUsersRuleDependentTypeIdRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/rules/{ruleId}/dependents/{ruleType}/{typeId}").withPathParameter("ruleId", this.ruleId).withPathParameter("ruleType", this.ruleType).withPathParameter("typeId", this.typeId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String ruleId, String ruleType, String typeId) {
        return new Builder().withRequiredParams(ruleId, ruleType, typeId);
    }

    public static class Builder {
        private final GetUsersRuleDependentTypeIdRequest request = new GetUsersRuleDependentTypeIdRequest();

        private Builder() {
        }

        public Builder withRuleId(String ruleId) {
            this.request.setRuleId(ruleId);
            return this;
        }

        public Builder withRuleType(String ruleType) {
            this.request.setRuleType(ruleType);
            return this;
        }

        public Builder withRuleType(ruleTypeValues ruleType) {
            this.request.setRuleType(ruleType.toString());
            return this;
        }

        public Builder withTypeId(String typeId) {
            this.request.setTypeId(typeId);
            return this;
        }

        public Builder withRequiredParams(String ruleId, String ruleType, String typeId) {
            this.request.setRuleId(ruleId);
            this.request.setRuleType(ruleType);
            this.request.setTypeId(typeId);
            return this;
        }

        public GetUsersRuleDependentTypeIdRequest build() {
            if (this.request.ruleId == null) {
                throw new IllegalStateException("Missing the required parameter 'ruleId' when building request for GetUsersRuleDependentTypeIdRequest.");
            }
            if (this.request.ruleType == null) {
                throw new IllegalStateException("Missing the required parameter 'ruleType' when building request for GetUsersRuleDependentTypeIdRequest.");
            }
            if (this.request.typeId == null) {
                throw new IllegalStateException("Missing the required parameter 'typeId' when building request for GetUsersRuleDependentTypeIdRequest.");
            }
            return this.request;
        }
    }

    public static enum ruleTypeValues {
        LEARNING("learning");

        private String value;

        private ruleTypeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ruleTypeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ruleTypeValues value : ruleTypeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ruleTypeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

