/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetAuthorizationRoleRequest {
    private String roleId;
    private Boolean userCount;
    private List<String> expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public GetAuthorizationRoleRequest withRoleId(String roleId) {
        this.setRoleId(roleId);
        return this;
    }

    public Boolean getUserCount() {
        return this.userCount;
    }

    public void setUserCount(Boolean userCount) {
        this.userCount = userCount;
    }

    public GetAuthorizationRoleRequest withUserCount(Boolean userCount) {
        this.setUserCount(userCount);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetAuthorizationRoleRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetAuthorizationRoleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.roleId == null) {
            throw new IllegalStateException("Missing the required parameter 'roleId' when building request for GetAuthorizationRoleRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/authorization/roles/{roleId}").withPathParameter("roleId", this.roleId).withQueryParameters("userCount", "", this.userCount).withQueryParameters("expand", "multi", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roleId) {
        return new Builder().withRequiredParams(roleId);
    }

    public static class Builder {
        private final GetAuthorizationRoleRequest request = new GetAuthorizationRoleRequest();

        private Builder() {
        }

        public Builder withRoleId(String roleId) {
            this.request.setRoleId(roleId);
            return this;
        }

        public Builder withUserCount(Boolean userCount) {
            this.request.setUserCount(userCount);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withRequiredParams(String roleId) {
            this.request.setRoleId(roleId);
            return this;
        }

        public GetAuthorizationRoleRequest build() {
            if (this.request.roleId == null) {
                throw new IllegalStateException("Missing the required parameter 'roleId' when building request for GetAuthorizationRoleRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        UNUSEDPERMISSIONS("unusedPermissions");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

