/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Schedule Adherence Configuration")
public class AdherenceSettings
implements Serializable {
    private Integer severeAlertThresholdMinutes = null;
    private Integer adherenceTargetPercent = null;
    private Integer adherenceExceptionThresholdSeconds = null;
    private Boolean nonOnQueueActivitiesEquivalent = null;
    private Boolean trackOnQueueActivity = null;
    private List<IgnoredActivityCategoriesEnum> ignoredActivityCategories = new ArrayList<IgnoredActivityCategoriesEnum>();

    public AdherenceSettings severeAlertThresholdMinutes(Integer severeAlertThresholdMinutes) {
        this.severeAlertThresholdMinutes = severeAlertThresholdMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The threshold in minutes where an alert will be triggered when an agent is considered severely out of adherence")
    @JsonProperty(value="severeAlertThresholdMinutes")
    public Integer getSevereAlertThresholdMinutes() {
        return this.severeAlertThresholdMinutes;
    }

    public void setSevereAlertThresholdMinutes(Integer severeAlertThresholdMinutes) {
        this.severeAlertThresholdMinutes = severeAlertThresholdMinutes;
    }

    public AdherenceSettings adherenceTargetPercent(Integer adherenceTargetPercent) {
        this.adherenceTargetPercent = adherenceTargetPercent;
        return this;
    }

    @ApiModelProperty(example="null", value="Target adherence percentage")
    @JsonProperty(value="adherenceTargetPercent")
    public Integer getAdherenceTargetPercent() {
        return this.adherenceTargetPercent;
    }

    public void setAdherenceTargetPercent(Integer adherenceTargetPercent) {
        this.adherenceTargetPercent = adherenceTargetPercent;
    }

    public AdherenceSettings adherenceExceptionThresholdSeconds(Integer adherenceExceptionThresholdSeconds) {
        this.adherenceExceptionThresholdSeconds = adherenceExceptionThresholdSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The threshold in seconds for which agents should not be penalized for being momentarily out of adherence")
    @JsonProperty(value="adherenceExceptionThresholdSeconds")
    public Integer getAdherenceExceptionThresholdSeconds() {
        return this.adherenceExceptionThresholdSeconds;
    }

    public void setAdherenceExceptionThresholdSeconds(Integer adherenceExceptionThresholdSeconds) {
        this.adherenceExceptionThresholdSeconds = adherenceExceptionThresholdSeconds;
    }

    public AdherenceSettings nonOnQueueActivitiesEquivalent(Boolean nonOnQueueActivitiesEquivalent) {
        this.nonOnQueueActivitiesEquivalent = nonOnQueueActivitiesEquivalent;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to treat all non-on-queue activities as equivalent for adherence purposes")
    @JsonProperty(value="nonOnQueueActivitiesEquivalent")
    public Boolean getNonOnQueueActivitiesEquivalent() {
        return this.nonOnQueueActivitiesEquivalent;
    }

    public void setNonOnQueueActivitiesEquivalent(Boolean nonOnQueueActivitiesEquivalent) {
        this.nonOnQueueActivitiesEquivalent = nonOnQueueActivitiesEquivalent;
    }

    public AdherenceSettings trackOnQueueActivity(Boolean trackOnQueueActivity) {
        this.trackOnQueueActivity = trackOnQueueActivity;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to track on-queue activities")
    @JsonProperty(value="trackOnQueueActivity")
    public Boolean getTrackOnQueueActivity() {
        return this.trackOnQueueActivity;
    }

    public void setTrackOnQueueActivity(Boolean trackOnQueueActivity) {
        this.trackOnQueueActivity = trackOnQueueActivity;
    }

    public AdherenceSettings ignoredActivityCategories(List<IgnoredActivityCategoriesEnum> ignoredActivityCategories) {
        this.ignoredActivityCategories = ignoredActivityCategories;
        return this;
    }

    @ApiModelProperty(example="null", value="Activity categories that should be ignored for adherence purposes")
    @JsonProperty(value="ignoredActivityCategories")
    public List<IgnoredActivityCategoriesEnum> getIgnoredActivityCategories() {
        return this.ignoredActivityCategories;
    }

    public void setIgnoredActivityCategories(List<IgnoredActivityCategoriesEnum> ignoredActivityCategories) {
        this.ignoredActivityCategories = ignoredActivityCategories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdherenceSettings adherenceSettings = (AdherenceSettings)o;
        return Objects.equals(this.severeAlertThresholdMinutes, adherenceSettings.severeAlertThresholdMinutes) && Objects.equals(this.adherenceTargetPercent, adherenceSettings.adherenceTargetPercent) && Objects.equals(this.adherenceExceptionThresholdSeconds, adherenceSettings.adherenceExceptionThresholdSeconds) && Objects.equals(this.nonOnQueueActivitiesEquivalent, adherenceSettings.nonOnQueueActivitiesEquivalent) && Objects.equals(this.trackOnQueueActivity, adherenceSettings.trackOnQueueActivity) && Objects.equals(this.ignoredActivityCategories, adherenceSettings.ignoredActivityCategories);
    }

    public int hashCode() {
        return Objects.hash(this.severeAlertThresholdMinutes, this.adherenceTargetPercent, this.adherenceExceptionThresholdSeconds, this.nonOnQueueActivitiesEquivalent, this.trackOnQueueActivity, this.ignoredActivityCategories);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdherenceSettings {\n");
        sb.append("    severeAlertThresholdMinutes: ").append(this.toIndentedString(this.severeAlertThresholdMinutes)).append("\n");
        sb.append("    adherenceTargetPercent: ").append(this.toIndentedString(this.adherenceTargetPercent)).append("\n");
        sb.append("    adherenceExceptionThresholdSeconds: ").append(this.toIndentedString(this.adherenceExceptionThresholdSeconds)).append("\n");
        sb.append("    nonOnQueueActivitiesEquivalent: ").append(this.toIndentedString(this.nonOnQueueActivitiesEquivalent)).append("\n");
        sb.append("    trackOnQueueActivity: ").append(this.toIndentedString(this.trackOnQueueActivity)).append("\n");
        sb.append("    ignoredActivityCategories: ").append(this.toIndentedString(this.ignoredActivityCategories)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IgnoredActivityCategoriesEnum {
        ONQUEUEWORK("OnQueueWork"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable"),
        UNSCHEDULED("Unscheduled");

        private String value;

        private IgnoredActivityCategoriesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IgnoredActivityCategoriesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (IgnoredActivityCategoriesEnum value : IgnoredActivityCategoriesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return IgnoredActivityCategoriesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

