/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class Variable
implements Serializable {
    private String name = null;
    private TypeEnum type = null;
    private ScopeEnum scope = null;
    private String description = null;

    public Variable() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public Variable name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the variable.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Variable type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The data type of the variable.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Variable scope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The scope that determines the variable's usage context within Guides runtime.")
    @JsonProperty(value="scope")
    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public Variable description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the variable used by Guides runtime for input/output handling.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)o;
        return Objects.equals(this.name, variable.name) && Objects.equals((Object)this.type, (Object)variable.type) && Objects.equals((Object)this.scope, (Object)variable.scope) && Objects.equals(this.description, variable.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.scope, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Variable {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STRING("String"),
        INTEGER("Integer"),
        NUMBER("Number"),
        BOOLEAN("Boolean");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ScopeEnumDeserializer.class)
    public static enum ScopeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INPUT("Input"),
        OUTPUT("Output"),
        INPUTANDOUTPUT("InputAndOutput");

        private String value;

        private ScopeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ScopeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ScopeEnum value : ScopeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ScopeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ScopeEnumDeserializer
    extends StdDeserializer<ScopeEnum> {
        public ScopeEnumDeserializer() {
            super(ScopeEnumDeserializer.class);
        }

        public ScopeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ScopeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

