/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AnalyticsQueryAggregation;
import com.mypurecloud.sdk.v2.model.PagingSpec;
import com.mypurecloud.sdk.v2.model.PresenceDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.RoutingStatusDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.UserDetailQueryFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UserDetailsQuery
implements Serializable {
    private String interval = null;
    private List<UserDetailQueryFilter> userFilters = null;
    private List<PresenceDetailQueryFilter> presenceFilters = null;
    private List<RoutingStatusDetailQueryFilter> routingStatusFilters = null;
    private OrderEnum order = null;
    private List<AnalyticsQueryAggregation> presenceAggregations = null;
    private List<AnalyticsQueryAggregation> routingStatusAggregations = null;
    private PagingSpec paging = null;

    public UserDetailsQuery() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.userFilters = new ArrayList<UserDetailQueryFilter>();
            this.presenceFilters = new ArrayList<PresenceDetailQueryFilter>();
            this.routingStatusFilters = new ArrayList<RoutingStatusDetailQueryFilter>();
            this.presenceAggregations = new ArrayList<AnalyticsQueryAggregation>();
            this.routingStatusAggregations = new ArrayList<AnalyticsQueryAggregation>();
        }
    }

    public UserDetailsQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies the date and time range of data being queried. Conversations MUST have started within this time range to potentially be included within the result set. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public UserDetailsQuery userFilters(List<UserDetailQueryFilter> userFilters) {
        this.userFilters = userFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target the users to retrieve data for")
    @JsonProperty(value="userFilters")
    public List<UserDetailQueryFilter> getUserFilters() {
        return this.userFilters;
    }

    public void setUserFilters(List<UserDetailQueryFilter> userFilters) {
        this.userFilters = userFilters;
    }

    public UserDetailsQuery presenceFilters(List<PresenceDetailQueryFilter> presenceFilters) {
        this.presenceFilters = presenceFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target system and organization presence-level data")
    @JsonProperty(value="presenceFilters")
    public List<PresenceDetailQueryFilter> getPresenceFilters() {
        return this.presenceFilters;
    }

    public void setPresenceFilters(List<PresenceDetailQueryFilter> presenceFilters) {
        this.presenceFilters = presenceFilters;
    }

    public UserDetailsQuery routingStatusFilters(List<RoutingStatusDetailQueryFilter> routingStatusFilters) {
        this.routingStatusFilters = routingStatusFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target agent routing status-level data")
    @JsonProperty(value="routingStatusFilters")
    public List<RoutingStatusDetailQueryFilter> getRoutingStatusFilters() {
        return this.routingStatusFilters;
    }

    public void setRoutingStatusFilters(List<RoutingStatusDetailQueryFilter> routingStatusFilters) {
        this.routingStatusFilters = routingStatusFilters;
    }

    public UserDetailsQuery order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(example="null", value="Sort the result set in ascending/descending order. Default is ascending")
    @JsonProperty(value="order")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public UserDetailsQuery presenceAggregations(List<AnalyticsQueryAggregation> presenceAggregations) {
        this.presenceAggregations = presenceAggregations;
        return this;
    }

    @ApiModelProperty(example="null", value="Include faceted search and aggregate roll-ups of presence data in your search results. This does not function as a filter, but rather, summary data about the presence results matching your filters")
    @JsonProperty(value="presenceAggregations")
    public List<AnalyticsQueryAggregation> getPresenceAggregations() {
        return this.presenceAggregations;
    }

    public void setPresenceAggregations(List<AnalyticsQueryAggregation> presenceAggregations) {
        this.presenceAggregations = presenceAggregations;
    }

    public UserDetailsQuery routingStatusAggregations(List<AnalyticsQueryAggregation> routingStatusAggregations) {
        this.routingStatusAggregations = routingStatusAggregations;
        return this;
    }

    @ApiModelProperty(example="null", value="Include faceted search and aggregate roll-ups of agent routing status data in your search results. This does not function as a filter, but rather, summary data about the agent routing status results matching your filters")
    @JsonProperty(value="routingStatusAggregations")
    public List<AnalyticsQueryAggregation> getRoutingStatusAggregations() {
        return this.routingStatusAggregations;
    }

    public void setRoutingStatusAggregations(List<AnalyticsQueryAggregation> routingStatusAggregations) {
        this.routingStatusAggregations = routingStatusAggregations;
    }

    public UserDetailsQuery paging(PagingSpec paging) {
        this.paging = paging;
        return this;
    }

    @ApiModelProperty(example="null", value="Page size and number to control iterating through large result sets. Default page size is 25")
    @JsonProperty(value="paging")
    public PagingSpec getPaging() {
        return this.paging;
    }

    public void setPaging(PagingSpec paging) {
        this.paging = paging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDetailsQuery userDetailsQuery = (UserDetailsQuery)o;
        return Objects.equals(this.interval, userDetailsQuery.interval) && Objects.equals(this.userFilters, userDetailsQuery.userFilters) && Objects.equals(this.presenceFilters, userDetailsQuery.presenceFilters) && Objects.equals(this.routingStatusFilters, userDetailsQuery.routingStatusFilters) && Objects.equals((Object)this.order, (Object)userDetailsQuery.order) && Objects.equals(this.presenceAggregations, userDetailsQuery.presenceAggregations) && Objects.equals(this.routingStatusAggregations, userDetailsQuery.routingStatusAggregations) && Objects.equals(this.paging, userDetailsQuery.paging);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.userFilters, this.presenceFilters, this.routingStatusFilters, this.order, this.presenceAggregations, this.routingStatusAggregations, this.paging});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserDetailsQuery {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    userFilters: ").append(this.toIndentedString(this.userFilters)).append("\n");
        sb.append("    presenceFilters: ").append(this.toIndentedString(this.presenceFilters)).append("\n");
        sb.append("    routingStatusFilters: ").append(this.toIndentedString(this.routingStatusFilters)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("    presenceAggregations: ").append(this.toIndentedString(this.presenceAggregations)).append("\n");
        sb.append("    routingStatusAggregations: ").append(this.toIndentedString(this.routingStatusAggregations)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OrderEnumDeserializer.class)
    public static enum OrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("asc"),
        DESC("desc"),
        UNORDERED("unordered");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OrderEnum value : OrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OrderEnumDeserializer
    extends StdDeserializer<OrderEnum> {
        public OrderEnumDeserializer() {
            super(OrderEnumDeserializer.class);
        }

        public OrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

