/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.NuanceBotCredentials;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Model for setting the launch configuration for a Nuance bot available to Genesys Cloud")
public class BotExecutionConfiguration
implements Serializable {
    private String botId = null;
    private String executionHost = null;
    private NuanceBotCredentials botCredentials = null;

    public BotExecutionConfiguration() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public BotExecutionConfiguration botId(String botId) {
        this.botId = botId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Nuance bot ID")
    @JsonProperty(value="botId")
    public String getBotId() {
        return this.botId;
    }

    public void setBotId(String botId) {
        this.botId = botId;
    }

    public BotExecutionConfiguration executionHost(String executionHost) {
        this.executionHost = executionHost;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The hostname to use when contacting Nuance to execute this bot")
    @JsonProperty(value="executionHost")
    public String getExecutionHost() {
        return this.executionHost;
    }

    public void setExecutionHost(String executionHost) {
        this.executionHost = executionHost;
    }

    public BotExecutionConfiguration botCredentials(NuanceBotCredentials botCredentials) {
        this.botCredentials = botCredentials;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The bot's launch credentials")
    @JsonProperty(value="botCredentials")
    public NuanceBotCredentials getBotCredentials() {
        return this.botCredentials;
    }

    public void setBotCredentials(NuanceBotCredentials botCredentials) {
        this.botCredentials = botCredentials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BotExecutionConfiguration botExecutionConfiguration = (BotExecutionConfiguration)o;
        return Objects.equals(this.botId, botExecutionConfiguration.botId) && Objects.equals(this.executionHost, botExecutionConfiguration.executionHost) && Objects.equals(this.botCredentials, botExecutionConfiguration.botCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.botId, this.executionHost, this.botCredentials);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BotExecutionConfiguration {\n");
        sb.append("    botId: ").append(this.toIndentedString(this.botId)).append("\n");
        sb.append("    executionHost: ").append(this.toIndentedString(this.executionHost)).append("\n");
        sb.append("    botCredentials: ").append(this.toIndentedString(this.botCredentials)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

