/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class VoicemailMailboxInfo
implements Serializable {
    private String id = null;
    private OwnerTypeEnum ownerType = null;
    private Long usageSizeBytes = null;
    private Integer totalCount = null;
    private Integer unreadCount = null;
    private Integer deletedCount = null;
    private Date createdDate = null;
    private Date modifiedDate = null;
    private Date newestUnreadDate = null;
    private Date oldestUnreadDate = null;
    private Date newestReadDate = null;
    private Date oldestReadDate = null;
    private String selfUri = null;

    public VoicemailMailboxInfo() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The owner type of the voicemail mailbox")
    @JsonProperty(value="ownerType")
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @ApiModelProperty(example="null", value="The total number of bytes for all voicemail message audio recordings")
    @JsonProperty(value="usageSizeBytes")
    public Long getUsageSizeBytes() {
        return this.usageSizeBytes;
    }

    @ApiModelProperty(example="null", value="The total number of voicemail messages")
    @JsonProperty(value="totalCount")
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @ApiModelProperty(example="null", value="The total number of voicemail messages marked as unread")
    @JsonProperty(value="unreadCount")
    public Integer getUnreadCount() {
        return this.unreadCount;
    }

    @ApiModelProperty(example="null", value="The total number of voicemail messages marked as deleted")
    @JsonProperty(value="deletedCount")
    public Integer getDeletedCount() {
        return this.deletedCount;
    }

    @ApiModelProperty(example="null", value="The date of the oldest voicemail message. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @ApiModelProperty(example="null", value="The date of the most recent voicemail message. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    @ApiModelProperty(example="null", value="The date of the most recent unread voicemail message. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="newestUnreadDate")
    public Date getNewestUnreadDate() {
        return this.newestUnreadDate;
    }

    @ApiModelProperty(example="null", value="The date of the most oldest unread voicemail message. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="oldestUnreadDate")
    public Date getOldestUnreadDate() {
        return this.oldestUnreadDate;
    }

    @ApiModelProperty(example="null", value="The date of the most recent read voicemail message. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="newestReadDate")
    public Date getNewestReadDate() {
        return this.newestReadDate;
    }

    @ApiModelProperty(example="null", value="The date of the most oldest read voicemail message. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="oldestReadDate")
    public Date getOldestReadDate() {
        return this.oldestReadDate;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoicemailMailboxInfo voicemailMailboxInfo = (VoicemailMailboxInfo)o;
        return Objects.equals(this.id, voicemailMailboxInfo.id) && Objects.equals((Object)this.ownerType, (Object)voicemailMailboxInfo.ownerType) && Objects.equals(this.usageSizeBytes, voicemailMailboxInfo.usageSizeBytes) && Objects.equals(this.totalCount, voicemailMailboxInfo.totalCount) && Objects.equals(this.unreadCount, voicemailMailboxInfo.unreadCount) && Objects.equals(this.deletedCount, voicemailMailboxInfo.deletedCount) && Objects.equals(this.createdDate, voicemailMailboxInfo.createdDate) && Objects.equals(this.modifiedDate, voicemailMailboxInfo.modifiedDate) && Objects.equals(this.newestUnreadDate, voicemailMailboxInfo.newestUnreadDate) && Objects.equals(this.oldestUnreadDate, voicemailMailboxInfo.oldestUnreadDate) && Objects.equals(this.newestReadDate, voicemailMailboxInfo.newestReadDate) && Objects.equals(this.oldestReadDate, voicemailMailboxInfo.oldestReadDate) && Objects.equals(this.selfUri, voicemailMailboxInfo.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.ownerType, this.usageSizeBytes, this.totalCount, this.unreadCount, this.deletedCount, this.createdDate, this.modifiedDate, this.newestUnreadDate, this.oldestUnreadDate, this.newestReadDate, this.oldestReadDate, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VoicemailMailboxInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    usageSizeBytes: ").append(this.toIndentedString(this.usageSizeBytes)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    unreadCount: ").append(this.toIndentedString(this.unreadCount)).append("\n");
        sb.append("    deletedCount: ").append(this.toIndentedString(this.deletedCount)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    newestUnreadDate: ").append(this.toIndentedString(this.newestUnreadDate)).append("\n");
        sb.append("    oldestUnreadDate: ").append(this.toIndentedString(this.oldestUnreadDate)).append("\n");
        sb.append("    newestReadDate: ").append(this.toIndentedString(this.newestReadDate)).append("\n");
        sb.append("    oldestReadDate: ").append(this.toIndentedString(this.oldestReadDate)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OwnerTypeEnumDeserializer.class)
    public static enum OwnerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USER("User"),
        GROUP("Group"),
        QUEUE("Queue");

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OwnerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OwnerTypeEnum value : OwnerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OwnerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OwnerTypeEnumDeserializer
    extends StdDeserializer<OwnerTypeEnum> {
        public OwnerTypeEnumDeserializer() {
            super(OwnerTypeEnumDeserializer.class);
        }

        public OwnerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OwnerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

