/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ReportingTurnAction;
import com.mypurecloud.sdk.v2.model.ReportingTurnIntent;
import com.mypurecloud.sdk.v2.model.ReportingTurnKnowledge;
import com.mypurecloud.sdk.v2.model.ReportingTurnKnowledgeEvents;
import com.mypurecloud.sdk.v2.model.SessionEndDetails;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ReportingTurn
implements Serializable {
    private String userInput = null;
    private List<String> botPrompts = null;
    private String sessionId = null;
    private ReportingTurnAction askAction = null;
    private ReportingTurnIntent intent = null;
    private ReportingTurnKnowledge knowledge = null;
    private ReportingTurnKnowledgeEvents knowledgeBaseEvents = null;
    private Date dateCreated = null;
    private Date dateCompleted = null;
    private AskActionResultEnum askActionResult = null;
    private SessionEndDetails sessionEndDetails = null;
    private AddressableEntityRef conversation = null;

    public ReportingTurn() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.botPrompts = new ArrayList<String>();
        }
    }

    public ReportingTurn userInput(String userInput) {
        this.userInput = userInput;
        return this;
    }

    @ApiModelProperty(example="null", value="The chosen user input associated with this reporting turn.")
    @JsonProperty(value="userInput")
    public String getUserInput() {
        return this.userInput;
    }

    public void setUserInput(String userInput) {
        this.userInput = userInput;
    }

    public ReportingTurn botPrompts(List<String> botPrompts) {
        this.botPrompts = botPrompts;
        return this;
    }

    @ApiModelProperty(example="null", value="The bot prompts associated with this reporting turn.")
    @JsonProperty(value="botPrompts")
    public List<String> getBotPrompts() {
        return this.botPrompts;
    }

    public void setBotPrompts(List<String> botPrompts) {
        this.botPrompts = botPrompts;
    }

    public ReportingTurn sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The bot session ID that this reporting turn is grouped under.")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public ReportingTurn askAction(ReportingTurnAction askAction) {
        this.askAction = askAction;
        return this;
    }

    @ApiModelProperty(example="null", value="The bot flow 'ask' action associated with this reporting turn (e.g. AskForIntent).")
    @JsonProperty(value="askAction")
    public ReportingTurnAction getAskAction() {
        return this.askAction;
    }

    public void setAskAction(ReportingTurnAction askAction) {
        this.askAction = askAction;
    }

    public ReportingTurn intent(ReportingTurnIntent intent) {
        this.intent = intent;
        return this;
    }

    @ApiModelProperty(example="null", value="The intent and associated slots detected during this reporting turn.")
    @JsonProperty(value="intent")
    public ReportingTurnIntent getIntent() {
        return this.intent;
    }

    public void setIntent(ReportingTurnIntent intent) {
        this.intent = intent;
    }

    public ReportingTurn knowledge(ReportingTurnKnowledge knowledge) {
        this.knowledge = knowledge;
        return this;
    }

    @ApiModelProperty(example="null", value="The knowledge data captured during this reporting turn.")
    @JsonProperty(value="knowledge")
    public ReportingTurnKnowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(ReportingTurnKnowledge knowledge) {
        this.knowledge = knowledge;
    }

    public ReportingTurn knowledgeBaseEvents(ReportingTurnKnowledgeEvents knowledgeBaseEvents) {
        this.knowledgeBaseEvents = knowledgeBaseEvents;
        return this;
    }

    @ApiModelProperty(example="null", value="The knowledge data captured during this reporting turn.")
    @JsonProperty(value="knowledgeBaseEvents")
    public ReportingTurnKnowledgeEvents getKnowledgeBaseEvents() {
        return this.knowledgeBaseEvents;
    }

    public void setKnowledgeBaseEvents(ReportingTurnKnowledgeEvents knowledgeBaseEvents) {
        this.knowledgeBaseEvents = knowledgeBaseEvents;
    }

    public ReportingTurn dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the original turn was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public ReportingTurn dateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the original turn was completed. Note: The 'interval' query param uses this timestamp to filter the output. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public void setDateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public ReportingTurn askActionResult(AskActionResultEnum askActionResult) {
        this.askActionResult = askActionResult;
        return this;
    }

    @ApiModelProperty(example="null", value="Result of the bot flow 'ask' action.")
    @JsonProperty(value="askActionResult")
    public AskActionResultEnum getAskActionResult() {
        return this.askActionResult;
    }

    public void setAskActionResult(AskActionResultEnum askActionResult) {
        this.askActionResult = askActionResult;
    }

    public ReportingTurn sessionEndDetails(SessionEndDetails sessionEndDetails) {
        this.sessionEndDetails = sessionEndDetails;
        return this;
    }

    @ApiModelProperty(example="null", value="The details related to end of bot flow session.")
    @JsonProperty(value="sessionEndDetails")
    public SessionEndDetails getSessionEndDetails() {
        return this.sessionEndDetails;
    }

    public void setSessionEndDetails(SessionEndDetails sessionEndDetails) {
        this.sessionEndDetails = sessionEndDetails;
    }

    @ApiModelProperty(example="null", value="The conversation details, across potentially multiple Bot Flow sessions.")
    @JsonProperty(value="conversation")
    public AddressableEntityRef getConversation() {
        return this.conversation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportingTurn reportingTurn = (ReportingTurn)o;
        return Objects.equals(this.userInput, reportingTurn.userInput) && Objects.equals(this.botPrompts, reportingTurn.botPrompts) && Objects.equals(this.sessionId, reportingTurn.sessionId) && Objects.equals(this.askAction, reportingTurn.askAction) && Objects.equals(this.intent, reportingTurn.intent) && Objects.equals(this.knowledge, reportingTurn.knowledge) && Objects.equals(this.knowledgeBaseEvents, reportingTurn.knowledgeBaseEvents) && Objects.equals(this.dateCreated, reportingTurn.dateCreated) && Objects.equals(this.dateCompleted, reportingTurn.dateCompleted) && Objects.equals((Object)this.askActionResult, (Object)reportingTurn.askActionResult) && Objects.equals(this.sessionEndDetails, reportingTurn.sessionEndDetails) && Objects.equals(this.conversation, reportingTurn.conversation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userInput, this.botPrompts, this.sessionId, this.askAction, this.intent, this.knowledge, this.knowledgeBaseEvents, this.dateCreated, this.dateCompleted, this.askActionResult, this.sessionEndDetails, this.conversation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportingTurn {\n");
        sb.append("    userInput: ").append(this.toIndentedString(this.userInput)).append("\n");
        sb.append("    botPrompts: ").append(this.toIndentedString(this.botPrompts)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    askAction: ").append(this.toIndentedString(this.askAction)).append("\n");
        sb.append("    intent: ").append(this.toIndentedString(this.intent)).append("\n");
        sb.append("    knowledge: ").append(this.toIndentedString(this.knowledge)).append("\n");
        sb.append("    knowledgeBaseEvents: ").append(this.toIndentedString(this.knowledgeBaseEvents)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    askActionResult: ").append(this.toIndentedString((Object)this.askActionResult)).append("\n");
        sb.append("    sessionEndDetails: ").append(this.toIndentedString(this.sessionEndDetails)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AskActionResultEnumDeserializer.class)
    public static enum AskActionResultEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUCCESSCOLLECTION("SuccessCollection"),
        SUCCESSCONFIRMATIONYES("SuccessConfirmationYes"),
        SUCCESSCONFIRMATIONNO("SuccessConfirmationNo"),
        SKIPPEDCOLLECTION("SkippedCollection"),
        PARTIALCOLLECTION("PartialCollection"),
        NOMATCHCOLLECTION("NoMatchCollection"),
        NOMATCHCONFIRMATION("NoMatchConfirmation"),
        AGENTREQUESTEDBYUSER("AgentRequestedByUser"),
        CONFIRMATIONREQUIRED("ConfirmationRequired"),
        ERROR("Error"),
        EXPRESSIONERROR("ExpressionError"),
        NOINPUTCOLLECTION("NoInputCollection"),
        NOINPUTCONFIRMATION("NoInputConfirmation"),
        DISAMBIGUATIONREQUIRED("DisambiguationRequired"),
        SUCCESSDISAMBIGUATION("SuccessDisambiguation"),
        SUCCESSDISAMBIGUATIONNONE("SuccessDisambiguationNone"),
        NOMATCHDISAMBIGUATION("NoMatchDisambiguation"),
        NOINPUTDISAMBIGUATION("NoInputDisambiguation");

        private String value;

        private AskActionResultEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AskActionResultEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AskActionResultEnum value : AskActionResultEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AskActionResultEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AskActionResultEnumDeserializer
    extends StdDeserializer<AskActionResultEnum> {
        public AskActionResultEnumDeserializer() {
            super(AskActionResultEnumDeserializer.class);
        }

        public AskActionResultEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AskActionResultEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

