/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.PerformancePredictionOutputs;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class PerformancePredictionResponse
implements Serializable {
    private String id = null;
    private LocalDate weekDate = null;
    private String scheduleId = null;
    private String downloadUrl = null;
    private PerformancePredictionOutputs downloadResult = null;
    private StateEnum state = null;
    private String selfUri = null;

    public PerformancePredictionResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public PerformancePredictionResponse weekDate(LocalDate weekDate) {
        this.weekDate = weekDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The weekDate of the short term forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="weekDate")
    public LocalDate getWeekDate() {
        return this.weekDate;
    }

    public void setWeekDate(LocalDate weekDate) {
        this.weekDate = weekDate;
    }

    public PerformancePredictionResponse scheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the schedule this performance prediction is associated with")
    @JsonProperty(value="scheduleId")
    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public PerformancePredictionResponse downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The url to GET the results of the performance prediction. This field is populated only if query state is 'Complete'")
    @JsonProperty(value="downloadUrl")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public PerformancePredictionResponse downloadResult(PerformancePredictionOutputs downloadResult) {
        this.downloadResult = downloadResult;
        return this;
    }

    @ApiModelProperty(example="null", value="Result will always come via downloadUrls; however the schema is included for documentation")
    @JsonProperty(value="downloadResult")
    public PerformancePredictionOutputs getDownloadResult() {
        return this.downloadResult;
    }

    public void setDownloadResult(PerformancePredictionOutputs downloadResult) {
        this.downloadResult = downloadResult;
    }

    public PerformancePredictionResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of the performance prediction")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerformancePredictionResponse performancePredictionResponse = (PerformancePredictionResponse)o;
        return Objects.equals(this.id, performancePredictionResponse.id) && Objects.equals(this.weekDate, performancePredictionResponse.weekDate) && Objects.equals(this.scheduleId, performancePredictionResponse.scheduleId) && Objects.equals(this.downloadUrl, performancePredictionResponse.downloadUrl) && Objects.equals(this.downloadResult, performancePredictionResponse.downloadResult) && Objects.equals((Object)this.state, (Object)performancePredictionResponse.state) && Objects.equals(this.selfUri, performancePredictionResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.weekDate, this.scheduleId, this.downloadUrl, this.downloadResult, this.state, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerformancePredictionResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    weekDate: ").append(this.toIndentedString(this.weekDate)).append("\n");
        sb.append("    scheduleId: ").append(this.toIndentedString(this.scheduleId)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    downloadResult: ").append(this.toIndentedString(this.downloadResult)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PROCESSING("Processing"),
        COMPLETE("Complete"),
        ERROR("Error");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

