/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.FormPageComponent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A page in a form with title, subtitle, and components")
public class FormPage
implements Serializable {
    private String title = null;
    private String subtitle = null;
    private List<FormPageComponent> pageComponents = null;

    public FormPage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.pageComponents = new ArrayList<FormPageComponent>();
        }
    }

    public FormPage title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Title of the page")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public FormPage subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Subtitle of the page")
    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public FormPage pageComponents(List<FormPageComponent> pageComponents) {
        this.pageComponents = pageComponents;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Components on this page")
    @JsonProperty(value="pageComponents")
    public List<FormPageComponent> getPageComponents() {
        return this.pageComponents;
    }

    public void setPageComponents(List<FormPageComponent> pageComponents) {
        this.pageComponents = pageComponents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormPage formPage = (FormPage)o;
        return Objects.equals(this.title, formPage.title) && Objects.equals(this.subtitle, formPage.subtitle) && Objects.equals(this.pageComponents, formPage.pageComponents);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.subtitle, this.pageComponents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormPage {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    subtitle: ").append(this.toIndentedString(this.subtitle)).append("\n");
        sb.append("    pageComponents: ").append(this.toIndentedString(this.pageComponents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

