/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DocumentTextProperties
implements Serializable {
    private FontSizeEnum fontSize = null;
    private String textColor = null;
    private String backgroundColor = null;

    public DocumentTextProperties() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public DocumentTextProperties fontSize(FontSizeEnum fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The font size for the text. The valid values in 'em'.")
    @JsonProperty(value="fontSize")
    public FontSizeEnum getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(FontSizeEnum fontSize) {
        this.fontSize = fontSize;
    }

    public DocumentTextProperties textColor(String textColor) {
        this.textColor = textColor;
        return this;
    }

    @ApiModelProperty(example="null", value="The text color for the text. The valid values in hex color code representation. For example black color - #000000")
    @JsonProperty(value="textColor")
    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public DocumentTextProperties backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(example="null", value="The background color for the text. The valid values in hex color code representation. For example black color - #000000")
    @JsonProperty(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentTextProperties documentTextProperties = (DocumentTextProperties)o;
        return Objects.equals((Object)this.fontSize, (Object)documentTextProperties.fontSize) && Objects.equals(this.textColor, documentTextProperties.textColor) && Objects.equals(this.backgroundColor, documentTextProperties.backgroundColor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fontSize, this.textColor, this.backgroundColor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentTextProperties {\n");
        sb.append("    fontSize: ").append(this.toIndentedString((Object)this.fontSize)).append("\n");
        sb.append("    textColor: ").append(this.toIndentedString(this.textColor)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FontSizeEnumDeserializer.class)
    public static enum FontSizeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        XXSMALL("XxSmall"),
        XSMALL("XSmall"),
        SMALL("Small"),
        MEDIUM("Medium"),
        LARGE("Large"),
        XLARGE("XLarge"),
        XXLARGE("XxLarge"),
        XXXLARGE("XxxLarge");

        private String value;

        private FontSizeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FontSizeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FontSizeEnum value : FontSizeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FontSizeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FontSizeEnumDeserializer
    extends StdDeserializer<FontSizeEnum> {
        public FontSizeEnumDeserializer() {
            super(FontSizeEnumDeserializer.class);
        }

        public FontSizeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FontSizeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

