/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.GuestMemberInfo;
import com.mypurecloud.sdk.v2.model.JourneyContext;
import com.mypurecloud.sdk.v2.model.WebChatRoutingTarget;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class CreateWebChatConversationRequest
implements Serializable {
    private String organizationId = null;
    private String deploymentId = null;
    private WebChatRoutingTarget routingTarget = null;
    private GuestMemberInfo memberInfo = null;
    private String memberAuthToken = null;
    private JourneyContext journeyContext = null;

    public CreateWebChatConversationRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CreateWebChatConversationRequest organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The organization identifier.")
    @JsonProperty(value="organizationId")
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public CreateWebChatConversationRequest deploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The web chat Deployment ID which contains the appropriate settings for this chat conversation.")
    @JsonProperty(value="deploymentId")
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public CreateWebChatConversationRequest routingTarget(WebChatRoutingTarget routingTarget) {
        this.routingTarget = routingTarget;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The routing information to use for the new chat conversation.")
    @JsonProperty(value="routingTarget")
    public WebChatRoutingTarget getRoutingTarget() {
        return this.routingTarget;
    }

    public void setRoutingTarget(WebChatRoutingTarget routingTarget) {
        this.routingTarget = routingTarget;
    }

    public CreateWebChatConversationRequest memberInfo(GuestMemberInfo memberInfo) {
        this.memberInfo = memberInfo;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The guest member info to use for the new chat conversation.")
    @JsonProperty(value="memberInfo")
    public GuestMemberInfo getMemberInfo() {
        return this.memberInfo;
    }

    public void setMemberInfo(GuestMemberInfo memberInfo) {
        this.memberInfo = memberInfo;
    }

    public CreateWebChatConversationRequest memberAuthToken(String memberAuthToken) {
        this.memberAuthToken = memberAuthToken;
        return this;
    }

    @ApiModelProperty(example="null", value="If the guest member is an authenticated member (ie, not anonymous) his JWT is provided here. The token will have been previously generated with the \"POST /api/v2/signeddata\" resource.")
    @JsonProperty(value="memberAuthToken")
    public String getMemberAuthToken() {
        return this.memberAuthToken;
    }

    public void setMemberAuthToken(String memberAuthToken) {
        this.memberAuthToken = memberAuthToken;
    }

    public CreateWebChatConversationRequest journeyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
        return this;
    }

    @ApiModelProperty(example="null", value="A subset of the Journey System's data relevant to this conversation/session request (for external linkage and internal usage/context).")
    @JsonProperty(value="journeyContext")
    public JourneyContext getJourneyContext() {
        return this.journeyContext;
    }

    public void setJourneyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWebChatConversationRequest createWebChatConversationRequest = (CreateWebChatConversationRequest)o;
        return Objects.equals(this.organizationId, createWebChatConversationRequest.organizationId) && Objects.equals(this.deploymentId, createWebChatConversationRequest.deploymentId) && Objects.equals(this.routingTarget, createWebChatConversationRequest.routingTarget) && Objects.equals(this.memberInfo, createWebChatConversationRequest.memberInfo) && Objects.equals(this.memberAuthToken, createWebChatConversationRequest.memberAuthToken) && Objects.equals(this.journeyContext, createWebChatConversationRequest.journeyContext);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.deploymentId, this.routingTarget, this.memberInfo, this.memberAuthToken, this.journeyContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWebChatConversationRequest {\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    deploymentId: ").append(this.toIndentedString(this.deploymentId)).append("\n");
        sb.append("    routingTarget: ").append(this.toIndentedString(this.routingTarget)).append("\n");
        sb.append("    memberInfo: ").append(this.toIndentedString(this.memberInfo)).append("\n");
        sb.append("    memberAuthToken: ").append(this.toIndentedString(this.memberAuthToken)).append("\n");
        sb.append("    journeyContext: ").append(this.toIndentedString(this.journeyContext)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

