/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class CopilotAction
implements Serializable {
    private ActionTypeEnum actionType = null;
    private Map<String, String> attributes = null;

    public CopilotAction() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CopilotAction actionType(ActionTypeEnum actionType) {
        this.actionType = actionType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of action.")
    @JsonProperty(value="actionType")
    public ActionTypeEnum getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionTypeEnum actionType) {
        this.actionType = actionType;
    }

    public CopilotAction attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="Action specific attributes, if any. Maximum 100 of string key-value pair allowed.")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopilotAction copilotAction = (CopilotAction)o;
        return Objects.equals((Object)this.actionType, (Object)copilotAction.actionType) && Objects.equals(this.attributes, copilotAction.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actionType, this.attributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CopilotAction {\n");
        sb.append("    actionType: ").append(this.toIndentedString((Object)this.actionType)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionTypeEnumDeserializer.class)
    public static enum ActionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        KNOWLEDGEARTICLE("KnowledgeArticle"),
        CANNEDRESPONSE("CannedResponse"),
        SCRIPT("Script"),
        CHECKLIST("Checklist"),
        THIRDPARTYACTION("ThirdPartyAction");

        private String value;

        private ActionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionTypeEnum value : ActionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionTypeEnumDeserializer
    extends StdDeserializer<ActionTypeEnum> {
        public ActionTypeEnumDeserializer() {
            super(ActionTypeEnumDeserializer.class);
        }

        public ActionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

