/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationSchemaAttribute;
import com.mypurecloud.sdk.v2.model.ConversationSchemaReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConversationSchemaData
implements Serializable {
    private ConversationSchemaReference schema = null;
    private List<ConversationSchemaAttribute> attributes = null;
    private OperatorEnum operator = null;

    public ConversationSchemaData() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.attributes = new ArrayList<ConversationSchemaAttribute>();
        }
    }

    public ConversationSchemaData schema(ConversationSchemaReference schema) {
        this.schema = schema;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Schema that defines attributes.")
    @JsonProperty(value="schema")
    public ConversationSchemaReference getSchema() {
        return this.schema;
    }

    public void setSchema(ConversationSchemaReference schema) {
        this.schema = schema;
    }

    public ConversationSchemaData attributes(List<ConversationSchemaAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Attributes to use for filtering; number of elements: min: 1, max: 5.")
    @JsonProperty(value="attributes")
    public List<ConversationSchemaAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<ConversationSchemaAttribute> attributes) {
        this.attributes = attributes;
    }

    public ConversationSchemaData operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="Operator to apply for multiple attributes, default: MatchAll")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationSchemaData conversationSchemaData = (ConversationSchemaData)o;
        return Objects.equals(this.schema, conversationSchemaData.schema) && Objects.equals(this.attributes, conversationSchemaData.attributes) && Objects.equals((Object)this.operator, (Object)conversationSchemaData.operator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schema, this.attributes, this.operator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationSchemaData {\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MATCHANY("MatchAny"),
        MATCHALL("MatchAll");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

