/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BusinessUnitReference;
import com.mypurecloud.sdk.v2.model.CapacityPlanReference;
import com.mypurecloud.sdk.v2.model.StaffingRequirementResultResponseTemplate;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class CapacityPlanStaffingRequirementResult
implements Serializable {
    private BusinessUnitReference businessUnit = null;
    private CapacityPlanReference capacityPlan = null;
    private StatusEnum status = null;
    private LocalDate referenceBusinessUnitDate = null;
    private GranularityEnum granularity = null;
    private ErrorCodeEnum errorCode = null;
    private String downloadUrl = null;
    private StaffingRequirementResultResponseTemplate downloadTemplate = null;

    public CapacityPlanStaffingRequirementResult() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CapacityPlanStaffingRequirementResult businessUnit(BusinessUnitReference businessUnit) {
        this.businessUnit = businessUnit;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The business unit to which the capacity plan belongs")
    @JsonProperty(value="businessUnit")
    public BusinessUnitReference getBusinessUnit() {
        return this.businessUnit;
    }

    public void setBusinessUnit(BusinessUnitReference businessUnit) {
        this.businessUnit = businessUnit;
    }

    public CapacityPlanStaffingRequirementResult capacityPlan(CapacityPlanReference capacityPlan) {
        this.capacityPlan = capacityPlan;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The capacity plan for which requirements are generated")
    @JsonProperty(value="capacityPlan")
    public CapacityPlanReference getCapacityPlan() {
        return this.capacityPlan;
    }

    public void setCapacityPlan(CapacityPlanReference capacityPlan) {
        this.capacityPlan = capacityPlan;
    }

    public CapacityPlanStaffingRequirementResult status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the requirement generation of the capacity plan")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CapacityPlanStaffingRequirementResult referenceBusinessUnitDate(LocalDate referenceBusinessUnitDate) {
        this.referenceBusinessUnitDate = referenceBusinessUnitDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The reference date for interval-based data for the requirements. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="referenceBusinessUnitDate")
    public LocalDate getReferenceBusinessUnitDate() {
        return this.referenceBusinessUnitDate;
    }

    public void setReferenceBusinessUnitDate(LocalDate referenceBusinessUnitDate) {
        this.referenceBusinessUnitDate = referenceBusinessUnitDate;
    }

    public CapacityPlanStaffingRequirementResult granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Granularity of the intervals")
    @JsonProperty(value="granularity")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public CapacityPlanStaffingRequirementResult errorCode(ErrorCodeEnum errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The error code when status is 'Failed'")
    @JsonProperty(value="errorCode")
    public ErrorCodeEnum getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCodeEnum errorCode) {
        this.errorCode = errorCode;
    }

    public CapacityPlanStaffingRequirementResult downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL to get the requirements results for the capacity plan. It will be populated if the status is 'Complete'")
    @JsonProperty(value="downloadUrl")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public CapacityPlanStaffingRequirementResult downloadTemplate(StaffingRequirementResultResponseTemplate downloadTemplate) {
        this.downloadTemplate = downloadTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="Staffing requirement results always come through downloadUrl, the schema included here is just for documentation")
    @JsonProperty(value="downloadTemplate")
    public StaffingRequirementResultResponseTemplate getDownloadTemplate() {
        return this.downloadTemplate;
    }

    public void setDownloadTemplate(StaffingRequirementResultResponseTemplate downloadTemplate) {
        this.downloadTemplate = downloadTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapacityPlanStaffingRequirementResult capacityPlanStaffingRequirementResult = (CapacityPlanStaffingRequirementResult)o;
        return Objects.equals(this.businessUnit, capacityPlanStaffingRequirementResult.businessUnit) && Objects.equals(this.capacityPlan, capacityPlanStaffingRequirementResult.capacityPlan) && Objects.equals((Object)this.status, (Object)capacityPlanStaffingRequirementResult.status) && Objects.equals(this.referenceBusinessUnitDate, capacityPlanStaffingRequirementResult.referenceBusinessUnitDate) && Objects.equals((Object)this.granularity, (Object)capacityPlanStaffingRequirementResult.granularity) && Objects.equals((Object)this.errorCode, (Object)capacityPlanStaffingRequirementResult.errorCode) && Objects.equals(this.downloadUrl, capacityPlanStaffingRequirementResult.downloadUrl) && Objects.equals(this.downloadTemplate, capacityPlanStaffingRequirementResult.downloadTemplate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.businessUnit, this.capacityPlan, this.status, this.referenceBusinessUnitDate, this.granularity, this.errorCode, this.downloadUrl, this.downloadTemplate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapacityPlanStaffingRequirementResult {\n");
        sb.append("    businessUnit: ").append(this.toIndentedString(this.businessUnit)).append("\n");
        sb.append("    capacityPlan: ").append(this.toIndentedString(this.capacityPlan)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    referenceBusinessUnitDate: ").append(this.toIndentedString(this.referenceBusinessUnitDate)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString((Object)this.errorCode)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    downloadTemplate: ").append(this.toIndentedString(this.downloadTemplate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PROCESSING("Processing"),
        COMPLETE("Complete"),
        CANCELED("Canceled"),
        ERROR("Error");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=GranularityEnumDeserializer.class)
    public static enum GranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WEEKLY("Weekly");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityEnum value : GranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ErrorCodeEnumDeserializer.class)
    public static enum ErrorCodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TIMEDOUT("TimedOut"),
        NODATA("NoData"),
        CLIENTDATAINVALID("ClientDataInvalid"),
        CONFIGURATIONINVALID("ConfigurationInvalid"),
        REQUIREMENTSFAILED("RequirementsFailed");

        private String value;

        private ErrorCodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ErrorCodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ErrorCodeEnum value : ErrorCodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ErrorCodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ErrorCodeEnumDeserializer
    extends StdDeserializer<ErrorCodeEnum> {
        public ErrorCodeEnumDeserializer() {
            super(ErrorCodeEnumDeserializer.class);
        }

        public ErrorCodeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ErrorCodeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class GranularityEnumDeserializer
    extends StdDeserializer<GranularityEnum> {
        public GranularityEnumDeserializer() {
            super(GranularityEnumDeserializer.class);
        }

        public GranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

