/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.StaffingGroupReference;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CapacityPlanStaffingGroupMetricChangeResponse
implements Serializable {
    private Integer numberOfWeeks = null;
    private Integer weekStartNumber = null;
    private Double value = null;
    private MetricEnum metric = null;
    private String notes = null;
    private List<StaffingGroupReference> staffingGroups = null;
    private UserReference createdBy = null;
    private Date createdDate = null;
    private Integer version = null;

    public CapacityPlanStaffingGroupMetricChangeResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.staffingGroups = new ArrayList<StaffingGroupReference>();
        }
    }

    public CapacityPlanStaffingGroupMetricChangeResponse numberOfWeeks(Integer numberOfWeeks) {
        this.numberOfWeeks = numberOfWeeks;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The number of weeks to which the metric change applies")
    @JsonProperty(value="numberOfWeeks")
    public Integer getNumberOfWeeks() {
        return this.numberOfWeeks;
    }

    public void setNumberOfWeeks(Integer numberOfWeeks) {
        this.numberOfWeeks = numberOfWeeks;
    }

    public CapacityPlanStaffingGroupMetricChangeResponse weekStartNumber(Integer weekStartNumber) {
        this.weekStartNumber = weekStartNumber;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start number of the week (starting from 1) to which the metric change applies, related to numberOfWeeks")
    @JsonProperty(value="weekStartNumber")
    public Integer getWeekStartNumber() {
        return this.weekStartNumber;
    }

    public void setWeekStartNumber(Integer weekStartNumber) {
        this.weekStartNumber = weekStartNumber;
    }

    public CapacityPlanStaffingGroupMetricChangeResponse value(Double value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The value of the metric")
    @JsonProperty(value="value")
    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public CapacityPlanStaffingGroupMetricChangeResponse metric(MetricEnum metric) {
        this.metric = metric;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The metric which is going to be modified for the selected staffing groups")
    @JsonProperty(value="metric")
    public MetricEnum getMetric() {
        return this.metric;
    }

    public void setMetric(MetricEnum metric) {
        this.metric = metric;
    }

    public CapacityPlanStaffingGroupMetricChangeResponse notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", value="Notes about the staffing groups metric changes")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public CapacityPlanStaffingGroupMetricChangeResponse staffingGroups(List<StaffingGroupReference> staffingGroups) {
        this.staffingGroups = staffingGroups;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The staffing groups affected by the metric change")
    @JsonProperty(value="staffingGroups")
    public List<StaffingGroupReference> getStaffingGroups() {
        return this.staffingGroups;
    }

    public void setStaffingGroups(List<StaffingGroupReference> staffingGroups) {
        this.staffingGroups = staffingGroups;
    }

    public CapacityPlanStaffingGroupMetricChangeResponse createdBy(UserReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user who created the metric change")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserReference createdBy) {
        this.createdBy = createdBy;
    }

    public CapacityPlanStaffingGroupMetricChangeResponse createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date the entity was created, in ISO-8601 format")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public CapacityPlanStaffingGroupMetricChangeResponse version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The version of the capacity plan")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapacityPlanStaffingGroupMetricChangeResponse capacityPlanStaffingGroupMetricChangeResponse = (CapacityPlanStaffingGroupMetricChangeResponse)o;
        return Objects.equals(this.numberOfWeeks, capacityPlanStaffingGroupMetricChangeResponse.numberOfWeeks) && Objects.equals(this.weekStartNumber, capacityPlanStaffingGroupMetricChangeResponse.weekStartNumber) && Objects.equals(this.value, capacityPlanStaffingGroupMetricChangeResponse.value) && Objects.equals((Object)this.metric, (Object)capacityPlanStaffingGroupMetricChangeResponse.metric) && Objects.equals(this.notes, capacityPlanStaffingGroupMetricChangeResponse.notes) && Objects.equals(this.staffingGroups, capacityPlanStaffingGroupMetricChangeResponse.staffingGroups) && Objects.equals(this.createdBy, capacityPlanStaffingGroupMetricChangeResponse.createdBy) && Objects.equals(this.createdDate, capacityPlanStaffingGroupMetricChangeResponse.createdDate) && Objects.equals(this.version, capacityPlanStaffingGroupMetricChangeResponse.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.numberOfWeeks, this.weekStartNumber, this.value, this.metric, this.notes, this.staffingGroups, this.createdBy, this.createdDate, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapacityPlanStaffingGroupMetricChangeResponse {\n");
        sb.append("    numberOfWeeks: ").append(this.toIndentedString(this.numberOfWeeks)).append("\n");
        sb.append("    weekStartNumber: ").append(this.toIndentedString(this.weekStartNumber)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString((Object)this.metric)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    staffingGroups: ").append(this.toIndentedString(this.staffingGroups)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MetricEnumDeserializer.class)
    public static enum MetricEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STARTINGWEEKLYFULLTIMEEQUIVALENTCOUNT("StartingWeeklyFullTimeEquivalentCount"),
        NEWHIRESFULLTIMEEQUIVALENTCOUNT("NewHiresFullTimeEquivalentCount"),
        ATTRITIONPERCENTAGE("AttritionPercentage"),
        SHRINKAGEPERCENTAGE("ShrinkagePercentage"),
        TRANSFERSFULLTIMEEQUIVALENTCOUNT("TransfersFullTimeEquivalentCount"),
        EXTRATIMEUNDERTIMEFULLTIMEEQUIVALENTCOUNT("ExtraTimeUnderTimeFullTimeEquivalentCount");

        private String value;

        private MetricEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricEnum value : MetricEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricEnumDeserializer
    extends StdDeserializer<MetricEnum> {
        public MetricEnumDeserializer() {
            super(MetricEnumDeserializer.class);
        }

        public MetricEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

