/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.TopicCriteria;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AdditionalMatchCriteria
implements Serializable {
    private List<TopicCriteria> topics = null;
    private MediaFilterEnum mediaFilter = null;

    public AdditionalMatchCriteria() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.topics = new ArrayList<TopicCriteria>();
        }
    }

    public AdditionalMatchCriteria topics(List<TopicCriteria> topics) {
        this.topics = topics;
        return this;
    }

    @ApiModelProperty(example="null", value="List of topics with specific data ingestion rules to filter messages for escalation.")
    @JsonProperty(value="topics")
    public List<TopicCriteria> getTopics() {
        return this.topics;
    }

    public void setTopics(List<TopicCriteria> topics) {
        this.topics = topics;
    }

    public AdditionalMatchCriteria mediaFilter(MediaFilterEnum mediaFilter) {
        this.mediaFilter = mediaFilter;
        return this;
    }

    @ApiModelProperty(example="null", value="Escalate message based on media presence. Not setting any value will escalate all types of msg.")
    @JsonProperty(value="mediaFilter")
    public MediaFilterEnum getMediaFilter() {
        return this.mediaFilter;
    }

    public void setMediaFilter(MediaFilterEnum mediaFilter) {
        this.mediaFilter = mediaFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalMatchCriteria additionalMatchCriteria = (AdditionalMatchCriteria)o;
        return Objects.equals(this.topics, additionalMatchCriteria.topics) && Objects.equals((Object)this.mediaFilter, (Object)additionalMatchCriteria.mediaFilter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topics, this.mediaFilter});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalMatchCriteria {\n");
        sb.append("    topics: ").append(this.toIndentedString(this.topics)).append("\n");
        sb.append("    mediaFilter: ").append(this.toIndentedString((Object)this.mediaFilter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaFilterEnumDeserializer.class)
    public static enum MediaFilterEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WITHMEDIA("WithMedia"),
        WITHOUTMEDIA("WithoutMedia");

        private String value;

        private MediaFilterEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaFilterEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaFilterEnum value : MediaFilterEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaFilterEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaFilterEnumDeserializer
    extends StdDeserializer<MediaFilterEnum> {
        public MediaFilterEnumDeserializer() {
            super(MediaFilterEnumDeserializer.class);
        }

        public MediaFilterEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaFilterEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

