/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetChatsMessageRequest {
    private String messageId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public GetChatsMessageRequest withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetChatsMessageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.messageId == null) {
            throw new IllegalStateException("Missing the required parameter 'messageId' when building request for GetChatsMessageRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/chats/messages/{messageId}").withPathParameter("messageId", this.messageId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String messageId) {
        return new Builder().withRequiredParams(messageId);
    }

    public static class Builder {
        private final GetChatsMessageRequest request = new GetChatsMessageRequest();

        private Builder() {
        }

        public Builder withMessageId(String messageId) {
            this.request.setMessageId(messageId);
            return this;
        }

        public Builder withRequiredParams(String messageId) {
            this.request.setMessageId(messageId);
            return this;
        }

        public GetChatsMessageRequest build() {
            if (this.request.messageId == null) {
                throw new IllegalStateException("Missing the required parameter 'messageId' when building request for GetChatsMessageRequest.");
            }
            return this.request;
        }
    }
}

