/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.SearchSort;
import com.mypurecloud.sdk.v2.model.TranscriptSearchCriteria;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TranscriptSearchRequest
implements Serializable {
    private SortOrderEnum sortOrder = null;
    private String sortBy = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private List<SearchSort> sort = null;
    private List<String> returnFields = null;
    private List<String> types = null;
    private List<TranscriptSearchCriteria> query = null;

    public TranscriptSearchRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.sort = new ArrayList<SearchSort>();
            this.returnFields = new ArrayList<String>();
            this.types = new ArrayList<String>();
            this.query = new ArrayList<TranscriptSearchCriteria>();
        }
    }

    public TranscriptSearchRequest sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="The sort order for results")
    @JsonProperty(value="sortOrder")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public TranscriptSearchRequest sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The field in the resource that you want to sort the results by")
    @JsonProperty(value="sortBy")
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public TranscriptSearchRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of results per page")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public TranscriptSearchRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The page of resources you want to retrieve")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public TranscriptSearchRequest sort(List<SearchSort> sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(example="null", value="Multi-value sort order, list of multiple sort values")
    @JsonProperty(value="sort")
    public List<SearchSort> getSort() {
        return this.sort;
    }

    public void setSort(List<SearchSort> sort) {
        this.sort = sort;
    }

    public TranscriptSearchRequest returnFields(List<String> returnFields) {
        this.returnFields = returnFields;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="returnFields")
    public List<String> getReturnFields() {
        return this.returnFields;
    }

    public void setReturnFields(List<String> returnFields) {
        this.returnFields = returnFields;
    }

    public TranscriptSearchRequest types(List<String> types) {
        this.types = types;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Resource domain type to search")
    @JsonProperty(value="types")
    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public TranscriptSearchRequest query(List<TranscriptSearchCriteria> query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", value="The search criteria")
    @JsonProperty(value="query")
    public List<TranscriptSearchCriteria> getQuery() {
        return this.query;
    }

    public void setQuery(List<TranscriptSearchCriteria> query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranscriptSearchRequest transcriptSearchRequest = (TranscriptSearchRequest)o;
        return Objects.equals((Object)this.sortOrder, (Object)transcriptSearchRequest.sortOrder) && Objects.equals(this.sortBy, transcriptSearchRequest.sortBy) && Objects.equals(this.pageSize, transcriptSearchRequest.pageSize) && Objects.equals(this.pageNumber, transcriptSearchRequest.pageNumber) && Objects.equals(this.sort, transcriptSearchRequest.sort) && Objects.equals(this.returnFields, transcriptSearchRequest.returnFields) && Objects.equals(this.types, transcriptSearchRequest.types) && Objects.equals(this.query, transcriptSearchRequest.query);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sortOrder, this.sortBy, this.pageSize, this.pageNumber, this.sort, this.returnFields, this.types, this.query});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TranscriptSearchRequest {\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString(this.sortBy)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    returnFields: ").append(this.toIndentedString(this.returnFields)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SortOrderEnumDeserializer.class)
    public static enum SortOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("ASC"),
        DESC("DESC"),
        SCORE("SCORE");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortOrderEnum value : SortOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SortOrderEnumDeserializer
    extends StdDeserializer<SortOrderEnum> {
        public SortOrderEnumDeserializer() {
            super(SortOrderEnumDeserializer.class);
        }

        public SortOrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortOrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

