/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class RowSearchPredicate
implements Serializable {
    private String columnId = null;
    private OperatorEnum operator = null;
    private String value = null;
    private SpecialEnum special = null;

    public RowSearchPredicate() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public RowSearchPredicate columnId(String columnId) {
        this.columnId = columnId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The decision table column identifier this predicate applies to")
    @JsonProperty(value="columnId")
    public String getColumnId() {
        return this.columnId;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }

    public RowSearchPredicate operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The search operator for this predicate")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public RowSearchPredicate value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The value that will be searched for in rows. Exactly one of 'value' or 'special' can be used.")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RowSearchPredicate special(SpecialEnum special) {
        this.special = special;
        return this;
    }

    @ApiModelProperty(example="null", value="The special value that will be searched for in rows. Exactly one of 'value' or 'special' can be used.")
    @JsonProperty(value="special")
    public SpecialEnum getSpecial() {
        return this.special;
    }

    public void setSpecial(SpecialEnum special) {
        this.special = special;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowSearchPredicate rowSearchPredicate = (RowSearchPredicate)o;
        return Objects.equals(this.columnId, rowSearchPredicate.columnId) && Objects.equals((Object)this.operator, (Object)rowSearchPredicate.operator) && Objects.equals(this.value, rowSearchPredicate.value) && Objects.equals((Object)this.special, (Object)rowSearchPredicate.special);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnId, this.operator, this.value, this.special});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RowSearchPredicate {\n");
        sb.append("    columnId: ").append(this.toIndentedString(this.columnId)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    special: ").append(this.toIndentedString((Object)this.special)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQUALS("Equals"),
        STARTSWITH("StartsWith"),
        GREATERTHAN("GreaterThan"),
        GREATERTHANOREQUALS("GreaterThanOrEquals"),
        LESSTHAN("LessThan"),
        LESSTHANOREQUALS("LessThanOrEquals"),
        CONTAINSITEM("ContainsItem");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SpecialEnumDeserializer.class)
    public static enum SpecialEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WILDCARD("Wildcard"),
        NULL("Null"),
        EMPTY("Empty"),
        CURRENTTIME("CurrentTime");

        private String value;

        private SpecialEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SpecialEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SpecialEnum value : SpecialEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SpecialEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SpecialEnumDeserializer
    extends StdDeserializer<SpecialEnum> {
        public SpecialEnumDeserializer() {
            super(SpecialEnumDeserializer.class);
        }

        public SpecialEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SpecialEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

