/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ProgressTransferEvent
implements Serializable {
    private String eventId = null;
    private Date eventDateTime = null;
    private String conversationId = null;
    private String commandId = null;
    private String objectCommunicationId = null;
    private String destinationCommunicationId = null;

    public ProgressTransferEvent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ProgressTransferEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique (V4 UUID) eventId for this event")
    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public ProgressTransferEvent eventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDateTime")
    public Date getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    public ProgressTransferEvent conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public ProgressTransferEvent commandId(String commandId) {
        this.commandId = commandId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) used to identify the transfer already started by the external platform.")
    @JsonProperty(value="commandId")
    public String getCommandId() {
        return this.commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public ProgressTransferEvent objectCommunicationId(String objectCommunicationId) {
        this.objectCommunicationId = objectCommunicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the communication that is being transferred.")
    @JsonProperty(value="objectCommunicationId")
    public String getObjectCommunicationId() {
        return this.objectCommunicationId;
    }

    public void setObjectCommunicationId(String objectCommunicationId) {
        this.objectCommunicationId = objectCommunicationId;
    }

    public ProgressTransferEvent destinationCommunicationId(String destinationCommunicationId) {
        this.destinationCommunicationId = destinationCommunicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the communication that is being transferred to.")
    @JsonProperty(value="destinationCommunicationId")
    public String getDestinationCommunicationId() {
        return this.destinationCommunicationId;
    }

    public void setDestinationCommunicationId(String destinationCommunicationId) {
        this.destinationCommunicationId = destinationCommunicationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgressTransferEvent progressTransferEvent = (ProgressTransferEvent)o;
        return Objects.equals(this.eventId, progressTransferEvent.eventId) && Objects.equals(this.eventDateTime, progressTransferEvent.eventDateTime) && Objects.equals(this.conversationId, progressTransferEvent.conversationId) && Objects.equals(this.commandId, progressTransferEvent.commandId) && Objects.equals(this.objectCommunicationId, progressTransferEvent.objectCommunicationId) && Objects.equals(this.destinationCommunicationId, progressTransferEvent.destinationCommunicationId);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventDateTime, this.conversationId, this.commandId, this.objectCommunicationId, this.destinationCommunicationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProgressTransferEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventDateTime: ").append(this.toIndentedString(this.eventDateTime)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    commandId: ").append(this.toIndentedString(this.commandId)).append("\n");
        sb.append("    objectCommunicationId: ").append(this.toIndentedString(this.objectCommunicationId)).append("\n");
        sb.append("    destinationCommunicationId: ").append(this.toIndentedString(this.destinationCommunicationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

