/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.EmailSettingReference;
import com.mypurecloud.sdk.v2.model.ImapSettings;
import com.mypurecloud.sdk.v2.model.MailFromResult;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class InboundDomainPatchRequest
implements Serializable {
    private MailFromResult mailFromSettings = null;
    private DomainEntityRef customSMTPServer = null;
    private ImapSettings imapSettings = null;
    private EmailSettingReference emailSetting = null;

    public InboundDomainPatchRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public InboundDomainPatchRequest mailFromSettings(MailFromResult mailFromSettings) {
        this.mailFromSettings = mailFromSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="The DNS settings if the inbound domain is using a custom Mail From. These settings can only be used on InboundDomains where subDomain is false.")
    @JsonProperty(value="mailFromSettings")
    public MailFromResult getMailFromSettings() {
        return this.mailFromSettings;
    }

    public void setMailFromSettings(MailFromResult mailFromSettings) {
        this.mailFromSettings = mailFromSettings;
    }

    public InboundDomainPatchRequest customSMTPServer(DomainEntityRef customSMTPServer) {
        this.customSMTPServer = customSMTPServer;
        return this;
    }

    @ApiModelProperty(example="null", value="The custom SMTP server integration to use when sending outbound emails from this domain.")
    @JsonProperty(value="customSMTPServer")
    public DomainEntityRef getCustomSMTPServer() {
        return this.customSMTPServer;
    }

    public void setCustomSMTPServer(DomainEntityRef customSMTPServer) {
        this.customSMTPServer = customSMTPServer;
    }

    public InboundDomainPatchRequest imapSettings(ImapSettings imapSettings) {
        this.imapSettings = imapSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="The IMAP server integration and settings to use for processing inbound emails.")
    @JsonProperty(value="imapSettings")
    public ImapSettings getImapSettings() {
        return this.imapSettings;
    }

    public void setImapSettings(ImapSettings imapSettings) {
        this.imapSettings = imapSettings;
    }

    public InboundDomainPatchRequest emailSetting(EmailSettingReference emailSetting) {
        this.emailSetting = emailSetting;
        return this;
    }

    @ApiModelProperty(example="null", value="The email settings to associate with this domain.")
    @JsonProperty(value="emailSetting")
    public EmailSettingReference getEmailSetting() {
        return this.emailSetting;
    }

    public void setEmailSetting(EmailSettingReference emailSetting) {
        this.emailSetting = emailSetting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundDomainPatchRequest inboundDomainPatchRequest = (InboundDomainPatchRequest)o;
        return Objects.equals(this.mailFromSettings, inboundDomainPatchRequest.mailFromSettings) && Objects.equals(this.customSMTPServer, inboundDomainPatchRequest.customSMTPServer) && Objects.equals(this.imapSettings, inboundDomainPatchRequest.imapSettings) && Objects.equals(this.emailSetting, inboundDomainPatchRequest.emailSetting);
    }

    public int hashCode() {
        return Objects.hash(this.mailFromSettings, this.customSMTPServer, this.imapSettings, this.emailSetting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundDomainPatchRequest {\n");
        sb.append("    mailFromSettings: ").append(this.toIndentedString(this.mailFromSettings)).append("\n");
        sb.append("    customSMTPServer: ").append(this.toIndentedString(this.customSMTPServer)).append("\n");
        sb.append("    imapSettings: ").append(this.toIndentedString(this.imapSettings)).append("\n");
        sb.append("    emailSetting: ").append(this.toIndentedString(this.emailSetting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

