/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ServiceLevel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class EmailMediaSettings
implements Serializable {
    private Boolean enableAutoAnswer = null;
    private Integer alertingTimeoutSeconds = null;
    private ServiceLevel serviceLevel = null;
    private Double autoAnswerAlertToneSeconds = null;
    private Double manualAnswerAlertToneSeconds = null;

    public EmailMediaSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public EmailMediaSettings enableAutoAnswer(Boolean enableAutoAnswer) {
        this.enableAutoAnswer = enableAutoAnswer;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if auto-answer is enabled for the given media type or subtype (default is false).  Subtype settings take precedence over media type settings.")
    @JsonProperty(value="enableAutoAnswer")
    public Boolean getEnableAutoAnswer() {
        return this.enableAutoAnswer;
    }

    public void setEnableAutoAnswer(Boolean enableAutoAnswer) {
        this.enableAutoAnswer = enableAutoAnswer;
    }

    public EmailMediaSettings alertingTimeoutSeconds(Integer alertingTimeoutSeconds) {
        this.alertingTimeoutSeconds = alertingTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The alerting timeout for the media type, in seconds")
    @JsonProperty(value="alertingTimeoutSeconds")
    public Integer getAlertingTimeoutSeconds() {
        return this.alertingTimeoutSeconds;
    }

    public void setAlertingTimeoutSeconds(Integer alertingTimeoutSeconds) {
        this.alertingTimeoutSeconds = alertingTimeoutSeconds;
    }

    public EmailMediaSettings serviceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    @ApiModelProperty(example="null", value="The targeted service level for the media type")
    @JsonProperty(value="serviceLevel")
    public ServiceLevel getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public EmailMediaSettings autoAnswerAlertToneSeconds(Double autoAnswerAlertToneSeconds) {
        this.autoAnswerAlertToneSeconds = autoAnswerAlertToneSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="How long to play the alerting tone for an auto-answer interaction")
    @JsonProperty(value="autoAnswerAlertToneSeconds")
    public Double getAutoAnswerAlertToneSeconds() {
        return this.autoAnswerAlertToneSeconds;
    }

    public void setAutoAnswerAlertToneSeconds(Double autoAnswerAlertToneSeconds) {
        this.autoAnswerAlertToneSeconds = autoAnswerAlertToneSeconds;
    }

    public EmailMediaSettings manualAnswerAlertToneSeconds(Double manualAnswerAlertToneSeconds) {
        this.manualAnswerAlertToneSeconds = manualAnswerAlertToneSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="How long to play the alerting tone for a manual-answer interaction")
    @JsonProperty(value="manualAnswerAlertToneSeconds")
    public Double getManualAnswerAlertToneSeconds() {
        return this.manualAnswerAlertToneSeconds;
    }

    public void setManualAnswerAlertToneSeconds(Double manualAnswerAlertToneSeconds) {
        this.manualAnswerAlertToneSeconds = manualAnswerAlertToneSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailMediaSettings emailMediaSettings = (EmailMediaSettings)o;
        return Objects.equals(this.enableAutoAnswer, emailMediaSettings.enableAutoAnswer) && Objects.equals(this.alertingTimeoutSeconds, emailMediaSettings.alertingTimeoutSeconds) && Objects.equals(this.serviceLevel, emailMediaSettings.serviceLevel) && Objects.equals(this.autoAnswerAlertToneSeconds, emailMediaSettings.autoAnswerAlertToneSeconds) && Objects.equals(this.manualAnswerAlertToneSeconds, emailMediaSettings.manualAnswerAlertToneSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.enableAutoAnswer, this.alertingTimeoutSeconds, this.serviceLevel, this.autoAnswerAlertToneSeconds, this.manualAnswerAlertToneSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailMediaSettings {\n");
        sb.append("    enableAutoAnswer: ").append(this.toIndentedString(this.enableAutoAnswer)).append("\n");
        sb.append("    alertingTimeoutSeconds: ").append(this.toIndentedString(this.alertingTimeoutSeconds)).append("\n");
        sb.append("    serviceLevel: ").append(this.toIndentedString(this.serviceLevel)).append("\n");
        sb.append("    autoAnswerAlertToneSeconds: ").append(this.toIndentedString(this.autoAnswerAlertToneSeconds)).append("\n");
        sb.append("    manualAnswerAlertToneSeconds: ").append(this.toIndentedString(this.manualAnswerAlertToneSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

