/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Contractual;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DecisionTableInputColumnExpression
implements Serializable {
    private Contractual contractual = null;
    private ComparatorEnum comparator = null;

    public DecisionTableInputColumnExpression() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public DecisionTableInputColumnExpression contractual(Contractual contractual) {
        this.contractual = contractual;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A value that is defined by a contract schema and used to form the left side of a logical condition.")
    @JsonProperty(value="contractual")
    public Contractual getContractual() {
        return this.contractual;
    }

    public void setContractual(Contractual contractual) {
        this.contractual = contractual;
    }

    public DecisionTableInputColumnExpression comparator(ComparatorEnum comparator) {
        this.comparator = comparator;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A comparator used to join the left and right sides of a logical condition.")
    @JsonProperty(value="comparator")
    public ComparatorEnum getComparator() {
        return this.comparator;
    }

    public void setComparator(ComparatorEnum comparator) {
        this.comparator = comparator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionTableInputColumnExpression decisionTableInputColumnExpression = (DecisionTableInputColumnExpression)o;
        return Objects.equals(this.contractual, decisionTableInputColumnExpression.contractual) && Objects.equals((Object)this.comparator, (Object)decisionTableInputColumnExpression.comparator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contractual, this.comparator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionTableInputColumnExpression {\n");
        sb.append("    contractual: ").append(this.toIndentedString(this.contractual)).append("\n");
        sb.append("    comparator: ").append(this.toIndentedString((Object)this.comparator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ComparatorEnumDeserializer.class)
    public static enum ComparatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQUALS("Equals"),
        NOTEQUALS("NotEquals"),
        GREATERTHAN("GreaterThan"),
        GREATERTHANOREQUALS("GreaterThanOrEquals"),
        LESSTHAN("LessThan"),
        LESSTHANOREQUALS("LessThanOrEquals"),
        STARTSWITH("StartsWith"),
        NOTSTARTSWITH("NotStartsWith"),
        ENDSWITH("EndsWith"),
        NOTENDSWITH("NotEndsWith"),
        CONTAINS("Contains"),
        NOTCONTAINS("NotContains"),
        CONTAINSANY("ContainsAny"),
        NOTCONTAINSANY("NotContainsAny"),
        CONTAINSALL("ContainsAll"),
        NOTCONTAINSALL("NotContainsAll"),
        CONTAINSEXACTLY("ContainsExactly"),
        NOTCONTAINSEXACTLY("NotContainsExactly"),
        CONTAINSSEQUENCE("ContainsSequence"),
        NOTCONTAINSSEQUENCE("NotContainsSequence"),
        ISSUBSET("IsSubset"),
        NOTISSUBSET("NotIsSubset"),
        ISSUBSEQUENCE("IsSubsequence"),
        NOTISSUBSEQUENCE("NotIsSubsequence");

        private String value;

        private ComparatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ComparatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ComparatorEnum value : ComparatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ComparatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ComparatorEnumDeserializer
    extends StdDeserializer<ComparatorEnum> {
        public ComparatorEnumDeserializer() {
            super(ComparatorEnumDeserializer.class);
        }

        public ComparatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ComparatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

