/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.CreateManagementUnitSettingsRequest;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CreateManagementUnitApiRequest
implements Serializable {
    private String name = null;
    private String timeZone = null;
    private StartDayOfWeekEnum startDayOfWeek = null;
    private CreateManagementUnitSettingsRequest settings = null;
    private String divisionId = null;
    private String businessUnitId = null;

    public CreateManagementUnitApiRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CreateManagementUnitApiRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the management unit")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateManagementUnitApiRequest timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="The default time zone to use for this management unit.  Moving to Business Unit")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public CreateManagementUnitApiRequest startDayOfWeek(StartDayOfWeekEnum startDayOfWeek) {
        this.startDayOfWeek = startDayOfWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="The configured first day of the week for scheduling and forecasting purposes. Moving to Business Unit")
    @JsonProperty(value="startDayOfWeek")
    public StartDayOfWeekEnum getStartDayOfWeek() {
        return this.startDayOfWeek;
    }

    public void setStartDayOfWeek(StartDayOfWeekEnum startDayOfWeek) {
        this.startDayOfWeek = startDayOfWeek;
    }

    public CreateManagementUnitApiRequest settings(CreateManagementUnitSettingsRequest settings) {
        this.settings = settings;
        return this;
    }

    @ApiModelProperty(example="null", value="The configuration for the management unit.  If omitted, reasonable defaults will be assigned")
    @JsonProperty(value="settings")
    public CreateManagementUnitSettingsRequest getSettings() {
        return this.settings;
    }

    public void setSettings(CreateManagementUnitSettingsRequest settings) {
        this.settings = settings;
    }

    public CreateManagementUnitApiRequest divisionId(String divisionId) {
        this.divisionId = divisionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the division to which this management unit belongs.  Defaults to home division ID")
    @JsonProperty(value="divisionId")
    public String getDivisionId() {
        return this.divisionId;
    }

    public void setDivisionId(String divisionId) {
        this.divisionId = divisionId;
    }

    public CreateManagementUnitApiRequest businessUnitId(String businessUnitId) {
        this.businessUnitId = businessUnitId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the business unit to which this management unit belongs")
    @JsonProperty(value="businessUnitId")
    public String getBusinessUnitId() {
        return this.businessUnitId;
    }

    public void setBusinessUnitId(String businessUnitId) {
        this.businessUnitId = businessUnitId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateManagementUnitApiRequest createManagementUnitApiRequest = (CreateManagementUnitApiRequest)o;
        return Objects.equals(this.name, createManagementUnitApiRequest.name) && Objects.equals(this.timeZone, createManagementUnitApiRequest.timeZone) && Objects.equals((Object)this.startDayOfWeek, (Object)createManagementUnitApiRequest.startDayOfWeek) && Objects.equals(this.settings, createManagementUnitApiRequest.settings) && Objects.equals(this.divisionId, createManagementUnitApiRequest.divisionId) && Objects.equals(this.businessUnitId, createManagementUnitApiRequest.businessUnitId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.timeZone, this.startDayOfWeek, this.settings, this.divisionId, this.businessUnitId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateManagementUnitApiRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    startDayOfWeek: ").append(this.toIndentedString((Object)this.startDayOfWeek)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    divisionId: ").append(this.toIndentedString(this.divisionId)).append("\n");
        sb.append("    businessUnitId: ").append(this.toIndentedString(this.businessUnitId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StartDayOfWeekEnumDeserializer.class)
    public static enum StartDayOfWeekEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private StartDayOfWeekEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StartDayOfWeekEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StartDayOfWeekEnum value : StartDayOfWeekEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StartDayOfWeekEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StartDayOfWeekEnumDeserializer
    extends StdDeserializer<StartDayOfWeekEnum> {
        public StartDayOfWeekEnumDeserializer() {
            super(StartDayOfWeekEnumDeserializer.class);
        }

        public StartDayOfWeekEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StartDayOfWeekEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

