/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AgentDirectRoutingBackupSettings
implements Serializable {
    private String queueId = null;
    private String userId = null;
    private Boolean waitForAgent = null;
    private Integer agentWaitSeconds = null;
    private List<String> backedUpUsers = null;

    public AgentDirectRoutingBackupSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.backedUpUsers = new ArrayList<String>();
        }
    }

    public AgentDirectRoutingBackupSettings queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of queue to be used as backup. If queueId and userId are both specified, queue behaves as secondary backup.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public AgentDirectRoutingBackupSettings userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of user to be used as backup. If queueId and userId are both specified, user behaves as primary backup.")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AgentDirectRoutingBackupSettings waitForAgent(Boolean waitForAgent) {
        this.waitForAgent = waitForAgent;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag indicating if Direct Routing interactions should wait for Direct Routing agent or go immediately to selected backup.")
    @JsonProperty(value="waitForAgent")
    public Boolean getWaitForAgent() {
        return this.waitForAgent;
    }

    public void setWaitForAgent(Boolean waitForAgent) {
        this.waitForAgent = waitForAgent;
    }

    public AgentDirectRoutingBackupSettings agentWaitSeconds(Integer agentWaitSeconds) {
        this.agentWaitSeconds = agentWaitSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Time (in seconds) that a Direct Routing interaction will wait for Direct Routing agent before going to selected backup. Valid range [60, 864000].")
    @JsonProperty(value="agentWaitSeconds")
    public Integer getAgentWaitSeconds() {
        return this.agentWaitSeconds;
    }

    public void setAgentWaitSeconds(Integer agentWaitSeconds) {
        this.agentWaitSeconds = agentWaitSeconds;
    }

    @ApiModelProperty(example="null", value="Set of users that this user is a backup for.")
    @JsonProperty(value="backedUpUsers")
    public List<String> getBackedUpUsers() {
        return this.backedUpUsers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentDirectRoutingBackupSettings agentDirectRoutingBackupSettings = (AgentDirectRoutingBackupSettings)o;
        return Objects.equals(this.queueId, agentDirectRoutingBackupSettings.queueId) && Objects.equals(this.userId, agentDirectRoutingBackupSettings.userId) && Objects.equals(this.waitForAgent, agentDirectRoutingBackupSettings.waitForAgent) && Objects.equals(this.agentWaitSeconds, agentDirectRoutingBackupSettings.agentWaitSeconds) && Objects.equals(this.backedUpUsers, agentDirectRoutingBackupSettings.backedUpUsers);
    }

    public int hashCode() {
        return Objects.hash(this.queueId, this.userId, this.waitForAgent, this.agentWaitSeconds, this.backedUpUsers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentDirectRoutingBackupSettings {\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    waitForAgent: ").append(this.toIndentedString(this.waitForAgent)).append("\n");
        sb.append("    agentWaitSeconds: ").append(this.toIndentedString(this.agentWaitSeconds)).append("\n");
        sb.append("    backedUpUsers: ").append(this.toIndentedString(this.backedUpUsers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

