/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AssistantQueueUsersBulkRemoveRequest;
import java.util.HashMap;
import java.util.Map;

public class PostAssistantQueueUsersBulkRemoveRequest {
    private String assistantId;
    private String queueId;
    private AssistantQueueUsersBulkRemoveRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public PostAssistantQueueUsersBulkRemoveRequest withAssistantId(String assistantId) {
        this.setAssistantId(assistantId);
        return this;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public PostAssistantQueueUsersBulkRemoveRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public AssistantQueueUsersBulkRemoveRequest getBody() {
        return this.body;
    }

    public void setBody(AssistantQueueUsersBulkRemoveRequest body) {
        this.body = body;
    }

    public PostAssistantQueueUsersBulkRemoveRequest withBody(AssistantQueueUsersBulkRemoveRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostAssistantQueueUsersBulkRemoveRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AssistantQueueUsersBulkRemoveRequest> withHttpInfo() {
        if (this.assistantId == null) {
            throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PostAssistantQueueUsersBulkRemoveRequest.");
        }
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PostAssistantQueueUsersBulkRemoveRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAssistantQueueUsersBulkRemoveRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/assistants/{assistantId}/queues/{queueId}/users/bulk/remove").withPathParameter("assistantId", this.assistantId).withPathParameter("queueId", this.queueId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String assistantId, String queueId, AssistantQueueUsersBulkRemoveRequest body) {
        return new Builder().withRequiredParams(assistantId, queueId, body);
    }

    public static class Builder {
        private final PostAssistantQueueUsersBulkRemoveRequest request = new PostAssistantQueueUsersBulkRemoveRequest();

        private Builder() {
        }

        public Builder withAssistantId(String assistantId) {
            this.request.setAssistantId(assistantId);
            return this;
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withBody(AssistantQueueUsersBulkRemoveRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String assistantId, String queueId, AssistantQueueUsersBulkRemoveRequest body) {
            this.request.setAssistantId(assistantId);
            this.request.setQueueId(queueId);
            this.request.setBody(body);
            return this;
        }

        public PostAssistantQueueUsersBulkRemoveRequest build() {
            if (this.request.assistantId == null) {
                throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PostAssistantQueueUsersBulkRemoveRequest.");
            }
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PostAssistantQueueUsersBulkRemoveRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAssistantQueueUsersBulkRemoveRequest.");
            }
            return this.request;
        }
    }
}

