/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AssistantQueueUsersBulkAddRequest;
import java.util.HashMap;
import java.util.Map;

public class PostAssistantQueueUsersBulkAddRequest {
    private String assistantId;
    private String queueId;
    private AssistantQueueUsersBulkAddRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public PostAssistantQueueUsersBulkAddRequest withAssistantId(String assistantId) {
        this.setAssistantId(assistantId);
        return this;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public PostAssistantQueueUsersBulkAddRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public AssistantQueueUsersBulkAddRequest getBody() {
        return this.body;
    }

    public void setBody(AssistantQueueUsersBulkAddRequest body) {
        this.body = body;
    }

    public PostAssistantQueueUsersBulkAddRequest withBody(AssistantQueueUsersBulkAddRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostAssistantQueueUsersBulkAddRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AssistantQueueUsersBulkAddRequest> withHttpInfo() {
        if (this.assistantId == null) {
            throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PostAssistantQueueUsersBulkAddRequest.");
        }
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PostAssistantQueueUsersBulkAddRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAssistantQueueUsersBulkAddRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/assistants/{assistantId}/queues/{queueId}/users/bulk/add").withPathParameter("assistantId", this.assistantId).withPathParameter("queueId", this.queueId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String assistantId, String queueId, AssistantQueueUsersBulkAddRequest body) {
        return new Builder().withRequiredParams(assistantId, queueId, body);
    }

    public static class Builder {
        private final PostAssistantQueueUsersBulkAddRequest request = new PostAssistantQueueUsersBulkAddRequest();

        private Builder() {
        }

        public Builder withAssistantId(String assistantId) {
            this.request.setAssistantId(assistantId);
            return this;
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withBody(AssistantQueueUsersBulkAddRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String assistantId, String queueId, AssistantQueueUsersBulkAddRequest body) {
            this.request.setAssistantId(assistantId);
            this.request.setQueueId(queueId);
            this.request.setBody(body);
            return this;
        }

        public PostAssistantQueueUsersBulkAddRequest build() {
            if (this.request.assistantId == null) {
                throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PostAssistantQueueUsersBulkAddRequest.");
            }
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PostAssistantQueueUsersBulkAddRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAssistantQueueUsersBulkAddRequest.");
            }
            return this.request;
        }
    }
}

