/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Update a Genesys Cloud user's presence from a given 3rd-party integration")
public class UCThirdPartyPresence
implements Serializable {
    private String email = null;
    private String presence = null;
    private String message = null;
    private Date dateModified = null;

    public UCThirdPartyPresence() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public UCThirdPartyPresence email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Primary Email address of the associated Genesys Cloud user.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UCThirdPartyPresence presence(String presence) {
        this.presence = presence;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Integration presence value.")
    @JsonProperty(value="presence")
    public String getPresence() {
        return this.presence;
    }

    public void setPresence(String presence) {
        this.presence = presence;
    }

    public UCThirdPartyPresence message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="null", value="Integration presence message.")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public UCThirdPartyPresence dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="ISO 8601 timestamp of presence value change.")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UCThirdPartyPresence uCThirdPartyPresence = (UCThirdPartyPresence)o;
        return Objects.equals(this.email, uCThirdPartyPresence.email) && Objects.equals(this.presence, uCThirdPartyPresence.presence) && Objects.equals(this.message, uCThirdPartyPresence.message) && Objects.equals(this.dateModified, uCThirdPartyPresence.dateModified);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.presence, this.message, this.dateModified);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UCThirdPartyPresence {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    presence: ").append(this.toIndentedString(this.presence)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

