/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="User information for a twitter account")
public class TwitterId
implements Serializable {
    private String id = null;
    private String name = null;
    private String screenName = null;
    private Boolean verified = null;
    private String profileUrl = null;

    public TwitterId() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public TwitterId id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="twitter user.id_str")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TwitterId name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="twitter user.name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TwitterId screenName(String screenName) {
        this.screenName = screenName;
        return this;
    }

    @ApiModelProperty(example="null", value="twitter user.screen_name")
    @JsonProperty(value="screenName")
    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    @ApiModelProperty(example="null", value="whether this data has been verified using the twitter API")
    @JsonProperty(value="verified")
    public Boolean getVerified() {
        return this.verified;
    }

    @ApiModelProperty(example="null", value="url of user's twitter profile")
    @JsonProperty(value="profileUrl")
    public String getProfileUrl() {
        return this.profileUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterId twitterId = (TwitterId)o;
        return Objects.equals(this.id, twitterId.id) && Objects.equals(this.name, twitterId.name) && Objects.equals(this.screenName, twitterId.screenName) && Objects.equals(this.verified, twitterId.verified) && Objects.equals(this.profileUrl, twitterId.profileUrl);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.screenName, this.verified, this.profileUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TwitterId {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    screenName: ").append(this.toIndentedString(this.screenName)).append("\n");
        sb.append("    verified: ").append(this.toIndentedString(this.verified)).append("\n");
        sb.append("    profileUrl: ").append(this.toIndentedString(this.profileUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

