/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationNormalizedMessage;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class SocialMediaMessageData
implements Serializable {
    private String id = null;
    private String name = null;
    private String providerMessageId = null;
    private Date timestamp = null;
    private String fromAddress = null;
    private String toAddress = null;
    private DirectionEnum direction = null;
    private MessengerTypeEnum messengerType = null;
    private StatusEnum status = null;
    private ConversationNormalizedMessage normalizedMessage = null;
    private List<ConversationNormalizedMessage> normalizedReceipts = null;
    private User createdBy = null;
    private String conversationId = null;
    private String selfUri = null;

    public SocialMediaMessageData() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.normalizedReceipts = new ArrayList<ConversationNormalizedMessage>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public SocialMediaMessageData name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SocialMediaMessageData providerMessageId(String providerMessageId) {
        this.providerMessageId = providerMessageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier of the message from provider")
    @JsonProperty(value="providerMessageId")
    public String getProviderMessageId() {
        return this.providerMessageId;
    }

    public void setProviderMessageId(String providerMessageId) {
        this.providerMessageId = providerMessageId;
    }

    public SocialMediaMessageData timestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public SocialMediaMessageData fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The sender of the text message.")
    @JsonProperty(value="fromAddress")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public SocialMediaMessageData toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipient of the text message.")
    @JsonProperty(value="toAddress")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public SocialMediaMessageData direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the message.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public SocialMediaMessageData messengerType(MessengerTypeEnum messengerType) {
        this.messengerType = messengerType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of text messenger.")
    @JsonProperty(value="messengerType")
    public MessengerTypeEnum getMessengerType() {
        return this.messengerType;
    }

    public void setMessengerType(MessengerTypeEnum messengerType) {
        this.messengerType = messengerType;
    }

    public SocialMediaMessageData status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the message.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @ApiModelProperty(example="null", value="The message into normalized format")
    @JsonProperty(value="normalizedMessage")
    public ConversationNormalizedMessage getNormalizedMessage() {
        return this.normalizedMessage;
    }

    @ApiModelProperty(example="null", value="The delivery event associated with this message in normalized format, if the message direction was outbound")
    @JsonProperty(value="normalizedReceipts")
    public List<ConversationNormalizedMessage> getNormalizedReceipts() {
        return this.normalizedReceipts;
    }

    public SocialMediaMessageData createdBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User who sent this message.")
    @JsonProperty(value="createdBy")
    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public SocialMediaMessageData conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the conversation of this message.")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocialMediaMessageData socialMediaMessageData = (SocialMediaMessageData)o;
        return Objects.equals(this.id, socialMediaMessageData.id) && Objects.equals(this.name, socialMediaMessageData.name) && Objects.equals(this.providerMessageId, socialMediaMessageData.providerMessageId) && Objects.equals(this.timestamp, socialMediaMessageData.timestamp) && Objects.equals(this.fromAddress, socialMediaMessageData.fromAddress) && Objects.equals(this.toAddress, socialMediaMessageData.toAddress) && Objects.equals((Object)this.direction, (Object)socialMediaMessageData.direction) && Objects.equals((Object)this.messengerType, (Object)socialMediaMessageData.messengerType) && Objects.equals((Object)this.status, (Object)socialMediaMessageData.status) && Objects.equals(this.normalizedMessage, socialMediaMessageData.normalizedMessage) && Objects.equals(this.normalizedReceipts, socialMediaMessageData.normalizedReceipts) && Objects.equals(this.createdBy, socialMediaMessageData.createdBy) && Objects.equals(this.conversationId, socialMediaMessageData.conversationId) && Objects.equals(this.selfUri, socialMediaMessageData.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.providerMessageId, this.timestamp, this.fromAddress, this.toAddress, this.direction, this.messengerType, this.status, this.normalizedMessage, this.normalizedReceipts, this.createdBy, this.conversationId, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SocialMediaMessageData {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    providerMessageId: ").append(this.toIndentedString(this.providerMessageId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    messengerType: ").append(this.toIndentedString((Object)this.messengerType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    normalizedMessage: ").append(this.toIndentedString(this.normalizedMessage)).append("\n");
        sb.append("    normalizedReceipts: ").append(this.toIndentedString(this.normalizedReceipts)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MessengerTypeEnumDeserializer.class)
    public static enum MessengerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("sms"),
        FACEBOOK("facebook"),
        TWITTER("twitter"),
        WHATSAPP("whatsapp"),
        WEBMESSAGING("webmessaging"),
        INSTAGRAM("instagram"),
        OPEN("open"),
        APPLE("apple");

        private String value;

        private MessengerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessengerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessengerTypeEnum value : MessengerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessengerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUED("queued"),
        SENT("sent"),
        FAILED("failed"),
        RECEIVED("received"),
        DELIVERY_SUCCESS("delivery-success"),
        DELIVERY_FAILED("delivery-failed"),
        READ("read"),
        REMOVED("removed"),
        PUBLISHED("published");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MessengerTypeEnumDeserializer
    extends StdDeserializer<MessengerTypeEnum> {
        public MessengerTypeEnumDeserializer() {
            super(MessengerTypeEnumDeserializer.class);
        }

        public MessengerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MessengerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

