/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ScheduleGenerationMessage;
import com.mypurecloud.sdk.v2.model.SchedulerMessageTypeSeverity;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ScheduleGenerationResult
implements Serializable {
    private Boolean failed = null;
    private String runId = null;
    private Integer messageCount = null;
    private List<ScheduleGenerationMessage> messages = null;
    private List<SchedulerMessageTypeSeverity> messageSeverities = null;

    public ScheduleGenerationResult() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.messages = new ArrayList<ScheduleGenerationMessage>();
            this.messageSeverities = new ArrayList<SchedulerMessageTypeSeverity>();
        }
    }

    public ScheduleGenerationResult failed(Boolean failed) {
        this.failed = failed;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the schedule generation run failed")
    @JsonProperty(value="failed")
    public Boolean getFailed() {
        return this.failed;
    }

    public void setFailed(Boolean failed) {
        this.failed = failed;
    }

    public ScheduleGenerationResult runId(String runId) {
        this.runId = runId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the schedule generation run. Reference this when requesting support")
    @JsonProperty(value="runId")
    public String getRunId() {
        return this.runId;
    }

    public void setRunId(String runId) {
        this.runId = runId;
    }

    public ScheduleGenerationResult messageCount(Integer messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of schedule generation messages for this schedule generation run")
    @JsonProperty(value="messageCount")
    public Integer getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
    }

    public ScheduleGenerationResult messages(List<ScheduleGenerationMessage> messages) {
        this.messages = messages;
        return this;
    }

    @ApiModelProperty(example="null", value="User facing messages related to the schedule generation run")
    @JsonProperty(value="messages")
    public List<ScheduleGenerationMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ScheduleGenerationMessage> messages) {
        this.messages = messages;
    }

    public ScheduleGenerationResult messageSeverities(List<SchedulerMessageTypeSeverity> messageSeverities) {
        this.messageSeverities = messageSeverities;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of messages by severity in this schedule generation run")
    @JsonProperty(value="messageSeverities")
    public List<SchedulerMessageTypeSeverity> getMessageSeverities() {
        return this.messageSeverities;
    }

    public void setMessageSeverities(List<SchedulerMessageTypeSeverity> messageSeverities) {
        this.messageSeverities = messageSeverities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleGenerationResult scheduleGenerationResult = (ScheduleGenerationResult)o;
        return Objects.equals(this.failed, scheduleGenerationResult.failed) && Objects.equals(this.runId, scheduleGenerationResult.runId) && Objects.equals(this.messageCount, scheduleGenerationResult.messageCount) && Objects.equals(this.messages, scheduleGenerationResult.messages) && Objects.equals(this.messageSeverities, scheduleGenerationResult.messageSeverities);
    }

    public int hashCode() {
        return Objects.hash(this.failed, this.runId, this.messageCount, this.messages, this.messageSeverities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleGenerationResult {\n");
        sb.append("    failed: ").append(this.toIndentedString(this.failed)).append("\n");
        sb.append("    runId: ").append(this.toIndentedString(this.runId)).append("\n");
        sb.append("    messageCount: ").append(this.toIndentedString(this.messageCount)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("    messageSeverities: ").append(this.toIndentedString(this.messageSeverities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

