/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.PredictorModelBrief;
import com.mypurecloud.sdk.v2.model.PredictorSchedule;
import com.mypurecloud.sdk.v2.model.PredictorWorkloadBalancing;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Predictor
implements Serializable {
    private String id = null;
    private List<AddressableEntityRef> queues = null;
    private String kpi = null;
    private Integer routingTimeoutSeconds = null;
    private PredictorSchedule schedule = null;
    private StateEnum state = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private PredictorWorkloadBalancing workloadBalancingConfig = null;
    private String errorCode = null;
    private List<PredictorModelBrief> models = null;
    private String selfUri = null;

    public Predictor() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.queues = new ArrayList<AddressableEntityRef>();
            this.models = new ArrayList<PredictorModelBrief>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Predictor queues(List<AddressableEntityRef> queues) {
        this.queues = queues;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The queue IDs associated with the predictor.")
    @JsonProperty(value="queues")
    public List<AddressableEntityRef> getQueues() {
        return this.queues;
    }

    public void setQueues(List<AddressableEntityRef> queues) {
        this.queues = queues;
    }

    public Predictor kpi(String kpi) {
        this.kpi = kpi;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The KPI that the predictor attempts to maximize/minimize.")
    @JsonProperty(value="kpi")
    public String getKpi() {
        return this.kpi;
    }

    public void setKpi(String kpi) {
        this.kpi = kpi;
    }

    public Predictor routingTimeoutSeconds(Integer routingTimeoutSeconds) {
        this.routingTimeoutSeconds = routingTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of seconds allocated to predictive routing before attempting a different routing method. This is a value between 12 and 900 seconds.")
    @JsonProperty(value="routingTimeoutSeconds")
    public Integer getRoutingTimeoutSeconds() {
        return this.routingTimeoutSeconds;
    }

    public void setRoutingTimeoutSeconds(Integer routingTimeoutSeconds) {
        this.routingTimeoutSeconds = routingTimeoutSeconds;
    }

    public Predictor schedule(PredictorSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="null", value="The predictor schedule that determines when the predictor is used for routing interactions.")
    @JsonProperty(value="schedule")
    public PredictorSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(PredictorSchedule schedule) {
        this.schedule = schedule;
    }

    @ApiModelProperty(example="null", value="The predictor state.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    @ApiModelProperty(example="null", value="DateTime indicating when the predictor was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="DateTime indicating when the predictor was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public Predictor workloadBalancingConfig(PredictorWorkloadBalancing workloadBalancingConfig) {
        this.workloadBalancingConfig = workloadBalancingConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="The predictor balancing configuration to enable workload balancing.")
    @JsonProperty(value="workloadBalancingConfig")
    public PredictorWorkloadBalancing getWorkloadBalancingConfig() {
        return this.workloadBalancingConfig;
    }

    public void setWorkloadBalancingConfig(PredictorWorkloadBalancing workloadBalancingConfig) {
        this.workloadBalancingConfig = workloadBalancingConfig;
    }

    @ApiModelProperty(example="null", value="Predictor error code - optional details on why the predictor went into error state.")
    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    @ApiModelProperty(example="null", value="Predictor's models")
    @JsonProperty(value="models")
    public List<PredictorModelBrief> getModels() {
        return this.models;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Predictor predictor = (Predictor)o;
        return Objects.equals(this.id, predictor.id) && Objects.equals(this.queues, predictor.queues) && Objects.equals(this.kpi, predictor.kpi) && Objects.equals(this.routingTimeoutSeconds, predictor.routingTimeoutSeconds) && Objects.equals(this.schedule, predictor.schedule) && Objects.equals((Object)this.state, (Object)predictor.state) && Objects.equals(this.dateCreated, predictor.dateCreated) && Objects.equals(this.dateModified, predictor.dateModified) && Objects.equals(this.workloadBalancingConfig, predictor.workloadBalancingConfig) && Objects.equals(this.errorCode, predictor.errorCode) && Objects.equals(this.models, predictor.models) && Objects.equals(this.selfUri, predictor.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.queues, this.kpi, this.routingTimeoutSeconds, this.schedule, this.state, this.dateCreated, this.dateModified, this.workloadBalancingConfig, this.errorCode, this.models, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Predictor {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    queues: ").append(this.toIndentedString(this.queues)).append("\n");
        sb.append("    kpi: ").append(this.toIndentedString(this.kpi)).append("\n");
        sb.append("    routingTimeoutSeconds: ").append(this.toIndentedString(this.routingTimeoutSeconds)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    workloadBalancingConfig: ").append(this.toIndentedString(this.workloadBalancingConfig)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    models: ").append(this.toIndentedString(this.models)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATED("Created"),
        ERROR("Error"),
        ACTIVE("Active");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

