/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Draft;
import com.mypurecloud.sdk.v2.model.MinerErrorInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Miner
implements Serializable {
    private String id = null;
    private String name = null;
    private LanguageEnum language = null;
    private MinerTypeEnum minerType = null;
    private Boolean seeding = null;
    private Date dateCreated = null;
    private StatusEnum status = null;
    private LocalDate conversationsDateRangeStart = null;
    private LocalDate conversationsDateRangeEnd = null;
    private Date dateCompleted = null;
    private String message = null;
    private MinerErrorInfo errorInfo = null;
    private MinerErrorInfo warningInfo = null;
    private Boolean conversationDataUploaded = null;
    private MediaTypeEnum mediaType = null;
    private ParticipantTypeEnum participantType = null;
    private List<String> queueIds = null;
    private Date dateTriggered = null;
    private Date dateModified = null;
    private Draft latestDraftVersion = null;
    private Integer conversationsFetchedCount = null;
    private Integer conversationsValidCount = null;
    private Integer getminedItemCount = null;
    private String selfUri = null;

    public Miner() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.queueIds = new ArrayList<String>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Miner name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Chat Corpus Name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Miner language(LanguageEnum language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="Language Localization code.")
    @JsonProperty(value="language")
    public LanguageEnum getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public Miner minerType(MinerTypeEnum minerType) {
        this.minerType = minerType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the miner, intent or topic.")
    @JsonProperty(value="minerType")
    public MinerTypeEnum getMinerType() {
        return this.minerType;
    }

    public void setMinerType(MinerTypeEnum minerType) {
        this.minerType = minerType;
    }

    public Miner seeding(Boolean seeding) {
        this.seeding = seeding;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag to indicate whether seeding is supported for this miner.")
    @JsonProperty(value="seeding")
    public Boolean getSeeding() {
        return this.seeding;
    }

    public void setSeeding(Boolean seeding) {
        this.seeding = seeding;
    }

    @ApiModelProperty(example="null", value="Date when the miner was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Status of the miner.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="Thu Jun 20 00:00:00 UTC 2019", value="Date from which the conversations need to be taken for mining. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="conversationsDateRangeStart")
    public LocalDate getConversationsDateRangeStart() {
        return this.conversationsDateRangeStart;
    }

    @ApiModelProperty(example="Fri Dec 20 00:00:00 UTC 2019", value="Date till which the conversations need to be taken for mining. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="conversationsDateRangeEnd")
    public LocalDate getConversationsDateRangeEnd() {
        return this.conversationsDateRangeEnd;
    }

    @ApiModelProperty(example="null", value="Date when the mining process was completed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    @ApiModelProperty(example="null", value="Mining message if present.")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @ApiModelProperty(example="null", value="Error Information")
    @JsonProperty(value="errorInfo")
    public MinerErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    @ApiModelProperty(example="null", value="Warning Information")
    @JsonProperty(value="warningInfo")
    public MinerErrorInfo getWarningInfo() {
        return this.warningInfo;
    }

    @ApiModelProperty(example="null", value="Flag to indicate whether data file to be mined was uploaded.")
    @JsonProperty(value="conversationDataUploaded")
    public Boolean getConversationDataUploaded() {
        return this.conversationDataUploaded;
    }

    @ApiModelProperty(example="null", value="Media type for filtering conversations.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    @ApiModelProperty(example="null", value="Type of the participant, either agent, customer or both.")
    @JsonProperty(value="participantType")
    public ParticipantTypeEnum getParticipantType() {
        return this.participantType;
    }

    @ApiModelProperty(example="null", value="List of queue IDs for filtering conversations.")
    @JsonProperty(value="queueIds")
    public List<String> getQueueIds() {
        return this.queueIds;
    }

    @ApiModelProperty(example="null", value="Date when the miner started execution. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateTriggered")
    public Date getDateTriggered() {
        return this.dateTriggered;
    }

    @ApiModelProperty(example="null", value="Date when the miner was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="Latest draft details of the miner.")
    @JsonProperty(value="latestDraftVersion")
    public Draft getLatestDraftVersion() {
        return this.latestDraftVersion;
    }

    @ApiModelProperty(example="null", value="Number of conversations/transcripts fetched.")
    @JsonProperty(value="conversationsFetchedCount")
    public Integer getConversationsFetchedCount() {
        return this.conversationsFetchedCount;
    }

    @ApiModelProperty(example="null", value="Number of conversations/recordings/transcripts that were found valid for mining purposes.")
    @JsonProperty(value="conversationsValidCount")
    public Integer getConversationsValidCount() {
        return this.conversationsValidCount;
    }

    @ApiModelProperty(example="null", value="Number of intents or topics based on the miner type.")
    @JsonProperty(value="getminedItemCount")
    public Integer getGetminedItemCount() {
        return this.getminedItemCount;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Miner miner = (Miner)o;
        return Objects.equals(this.id, miner.id) && Objects.equals(this.name, miner.name) && Objects.equals((Object)this.language, (Object)miner.language) && Objects.equals((Object)this.minerType, (Object)miner.minerType) && Objects.equals(this.seeding, miner.seeding) && Objects.equals(this.dateCreated, miner.dateCreated) && Objects.equals((Object)this.status, (Object)miner.status) && Objects.equals(this.conversationsDateRangeStart, miner.conversationsDateRangeStart) && Objects.equals(this.conversationsDateRangeEnd, miner.conversationsDateRangeEnd) && Objects.equals(this.dateCompleted, miner.dateCompleted) && Objects.equals(this.message, miner.message) && Objects.equals(this.errorInfo, miner.errorInfo) && Objects.equals(this.warningInfo, miner.warningInfo) && Objects.equals(this.conversationDataUploaded, miner.conversationDataUploaded) && Objects.equals((Object)this.mediaType, (Object)miner.mediaType) && Objects.equals((Object)this.participantType, (Object)miner.participantType) && Objects.equals(this.queueIds, miner.queueIds) && Objects.equals(this.dateTriggered, miner.dateTriggered) && Objects.equals(this.dateModified, miner.dateModified) && Objects.equals(this.latestDraftVersion, miner.latestDraftVersion) && Objects.equals(this.conversationsFetchedCount, miner.conversationsFetchedCount) && Objects.equals(this.conversationsValidCount, miner.conversationsValidCount) && Objects.equals(this.getminedItemCount, miner.getminedItemCount) && Objects.equals(this.selfUri, miner.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.language, this.minerType, this.seeding, this.dateCreated, this.status, this.conversationsDateRangeStart, this.conversationsDateRangeEnd, this.dateCompleted, this.message, this.errorInfo, this.warningInfo, this.conversationDataUploaded, this.mediaType, this.participantType, this.queueIds, this.dateTriggered, this.dateModified, this.latestDraftVersion, this.conversationsFetchedCount, this.conversationsValidCount, this.getminedItemCount, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Miner {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    minerType: ").append(this.toIndentedString((Object)this.minerType)).append("\n");
        sb.append("    seeding: ").append(this.toIndentedString(this.seeding)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    conversationsDateRangeStart: ").append(this.toIndentedString(this.conversationsDateRangeStart)).append("\n");
        sb.append("    conversationsDateRangeEnd: ").append(this.toIndentedString(this.conversationsDateRangeEnd)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    warningInfo: ").append(this.toIndentedString(this.warningInfo)).append("\n");
        sb.append("    conversationDataUploaded: ").append(this.toIndentedString(this.conversationDataUploaded)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    participantType: ").append(this.toIndentedString((Object)this.participantType)).append("\n");
        sb.append("    queueIds: ").append(this.toIndentedString(this.queueIds)).append("\n");
        sb.append("    dateTriggered: ").append(this.toIndentedString(this.dateTriggered)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    latestDraftVersion: ").append(this.toIndentedString(this.latestDraftVersion)).append("\n");
        sb.append("    conversationsFetchedCount: ").append(this.toIndentedString(this.conversationsFetchedCount)).append("\n");
        sb.append("    conversationsValidCount: ").append(this.toIndentedString(this.conversationsValidCount)).append("\n");
        sb.append("    getminedItemCount: ").append(this.toIndentedString(this.getminedItemCount)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LanguageEnumDeserializer.class)
    public static enum LanguageEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EN_US("en-us"),
        EN_GB("en-gb"),
        EN_AU("en-au"),
        EN_IN("en-in"),
        EN_ZA("en-za"),
        ES_US("es-us"),
        ES_ES("es-es"),
        FR_FR("fr-fr"),
        FR_CA("fr-ca"),
        DE_DE("de-de"),
        PT_PT("pt-pt"),
        PT_BR("pt-br"),
        IT_IT("it-it"),
        NL_NL("nl-nl"),
        DE_CH("de-ch"),
        JA_JP("ja-jp"),
        KO_KR("ko-kr"),
        HI_IN("hi-in"),
        AR_001("ar-001"),
        AR_AE("ar-ae"),
        AR_BH("ar-bh"),
        AR_EG("ar-eg"),
        AR_IL("ar-il"),
        AR_SA("ar-sa"),
        AR_TN("ar-tn");

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LanguageEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LanguageEnum value : LanguageEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LanguageEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MinerTypeEnumDeserializer.class)
    public static enum MinerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INTENT("Intent"),
        TOPIC("Topic");

        private String value;

        private MinerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MinerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MinerTypeEnum value : MinerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MinerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NOTSTARTED("NotStarted"),
        FETCHINGCONVERSATIONIDS("FetchingConversationIds"),
        CONVERSATIONIDSFETCHED("ConversationIdsFetched"),
        CONVERSATIONIDSFETCHERROR("ConversationIdsFetchError"),
        FETCHINGCONVERSATIONS("FetchingConversations"),
        CONVERSATIONSFETCHED("ConversationsFetched"),
        CONVERSATIONSFETCHERROR("ConversationsFetchError"),
        QUEUED("Queued"),
        QUEUINGERROR("QueuingError"),
        MININGSTARTED("MiningStarted"),
        MASKINGUTTERANCES("MaskingUtterances"),
        MASKINGERROR("MaskingError"),
        COMPUTINGANALYTICS("ComputingAnalytics"),
        COMPUTINGANALYTICSERROR("ComputingAnalyticsError"),
        MININGCOMPLETED("MiningCompleted"),
        MININGERROR("MiningError"),
        MODELVALIDATIONERROR("ModelValidationError"),
        DELETED("Deleted");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CHAT("Chat"),
        CALL("Call"),
        MESSAGE("Message"),
        EMAIL("Email");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ParticipantTypeEnumDeserializer.class)
    public static enum ParticipantTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CUSTOMER("Customer"),
        AGENT("Agent"),
        BOTH("Both");

        private String value;

        private ParticipantTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ParticipantTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ParticipantTypeEnum value : ParticipantTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ParticipantTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ParticipantTypeEnumDeserializer
    extends StdDeserializer<ParticipantTypeEnum> {
        public ParticipantTypeEnumDeserializer() {
            super(ParticipantTypeEnumDeserializer.class);
        }

        public ParticipantTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ParticipantTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MinerTypeEnumDeserializer
    extends StdDeserializer<MinerTypeEnum> {
        public MinerTypeEnumDeserializer() {
            super(MinerTypeEnumDeserializer.class);
        }

        public MinerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MinerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class LanguageEnumDeserializer
    extends StdDeserializer<LanguageEnum> {
        public LanguageEnumDeserializer() {
            super(LanguageEnumDeserializer.class);
        }

        public LanguageEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LanguageEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

