/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MediaIceStatistics;
import com.mypurecloud.sdk.v2.model.MediaRtpStatistics;
import com.mypurecloud.sdk.v2.model.MediaStatisticsClientInfo;
import com.mypurecloud.sdk.v2.model.MediaStatisticsTrunkInfo;
import com.mypurecloud.sdk.v2.model.NamedEntity;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class MediaEndpointStatistics
implements Serializable {
    private MediaStatisticsTrunkInfo trunk = null;
    private NamedEntity station = null;
    private NamedEntity user = null;
    private MediaIceStatistics ice = null;
    private MediaRtpStatistics rtp = null;
    private Integer reconnectAttempts = null;
    private SourceTypeEnum sourceType = null;
    private MediaStatisticsClientInfo clientInfo = null;
    private Date dateCreated = null;
    private Date dateProcessed = null;

    public MediaEndpointStatistics() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public MediaEndpointStatistics trunk(MediaStatisticsTrunkInfo trunk) {
        this.trunk = trunk;
        return this;
    }

    @ApiModelProperty(example="null", value="Trunk information utilized when creating the media endpoint")
    @JsonProperty(value="trunk")
    public MediaStatisticsTrunkInfo getTrunk() {
        return this.trunk;
    }

    public void setTrunk(MediaStatisticsTrunkInfo trunk) {
        this.trunk = trunk;
    }

    public MediaEndpointStatistics station(NamedEntity station) {
        this.station = station;
        return this;
    }

    @ApiModelProperty(example="null", value="Station information associated with media endpoint")
    @JsonProperty(value="station")
    public NamedEntity getStation() {
        return this.station;
    }

    public void setStation(NamedEntity station) {
        this.station = station;
    }

    public MediaEndpointStatistics user(NamedEntity user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="User information associated media endpoint")
    @JsonProperty(value="user")
    public NamedEntity getUser() {
        return this.user;
    }

    public void setUser(NamedEntity user) {
        this.user = user;
    }

    public MediaEndpointStatistics ice(MediaIceStatistics ice) {
        this.ice = ice;
        return this;
    }

    @ApiModelProperty(example="null", value="The ICE protocol statistics and details. Reference: https://www.rfc-editor.org/rfc/rfc5245")
    @JsonProperty(value="ice")
    public MediaIceStatistics getIce() {
        return this.ice;
    }

    public void setIce(MediaIceStatistics ice) {
        this.ice = ice;
    }

    public MediaEndpointStatistics rtp(MediaRtpStatistics rtp) {
        this.rtp = rtp;
        return this;
    }

    @ApiModelProperty(example="null", value="Statistics of sent and received RTP. Reference: https://www.rfc-editor.org/rfc/rfc3550")
    @JsonProperty(value="rtp")
    public MediaRtpStatistics getRtp() {
        return this.rtp;
    }

    public void setRtp(MediaRtpStatistics rtp) {
        this.rtp = rtp;
    }

    public MediaEndpointStatistics reconnectAttempts(Integer reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
        return this;
    }

    @ApiModelProperty(example="null", value="Media reconnect attempt count")
    @JsonProperty(value="reconnectAttempts")
    public Integer getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    public MediaEndpointStatistics sourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @ApiModelProperty(example="null", value="Source type of media endpoint")
    @JsonProperty(value="sourceType")
    public SourceTypeEnum getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public MediaEndpointStatistics clientInfo(MediaStatisticsClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Client information associated with media endpoint")
    @JsonProperty(value="clientInfo")
    public MediaStatisticsClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(MediaStatisticsClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public MediaEndpointStatistics dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Media endpoint statistics creation time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public MediaEndpointStatistics dateProcessed(Date dateProcessed) {
        this.dateProcessed = dateProcessed;
        return this;
    }

    @ApiModelProperty(example="null", value="Media endpoint statistics processed time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateProcessed")
    public Date getDateProcessed() {
        return this.dateProcessed;
    }

    public void setDateProcessed(Date dateProcessed) {
        this.dateProcessed = dateProcessed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaEndpointStatistics mediaEndpointStatistics = (MediaEndpointStatistics)o;
        return Objects.equals(this.trunk, mediaEndpointStatistics.trunk) && Objects.equals(this.station, mediaEndpointStatistics.station) && Objects.equals(this.user, mediaEndpointStatistics.user) && Objects.equals(this.ice, mediaEndpointStatistics.ice) && Objects.equals(this.rtp, mediaEndpointStatistics.rtp) && Objects.equals(this.reconnectAttempts, mediaEndpointStatistics.reconnectAttempts) && Objects.equals((Object)this.sourceType, (Object)mediaEndpointStatistics.sourceType) && Objects.equals(this.clientInfo, mediaEndpointStatistics.clientInfo) && Objects.equals(this.dateCreated, mediaEndpointStatistics.dateCreated) && Objects.equals(this.dateProcessed, mediaEndpointStatistics.dateProcessed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.trunk, this.station, this.user, this.ice, this.rtp, this.reconnectAttempts, this.sourceType, this.clientInfo, this.dateCreated, this.dateProcessed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaEndpointStatistics {\n");
        sb.append("    trunk: ").append(this.toIndentedString(this.trunk)).append("\n");
        sb.append("    station: ").append(this.toIndentedString(this.station)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    ice: ").append(this.toIndentedString(this.ice)).append("\n");
        sb.append("    rtp: ").append(this.toIndentedString(this.rtp)).append("\n");
        sb.append("    reconnectAttempts: ").append(this.toIndentedString(this.reconnectAttempts)).append("\n");
        sb.append("    sourceType: ").append(this.toIndentedString((Object)this.sourceType)).append("\n");
        sb.append("    clientInfo: ").append(this.toIndentedString(this.clientInfo)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateProcessed: ").append(this.toIndentedString(this.dateProcessed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SourceTypeEnumDeserializer.class)
    public static enum SourceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CLIENT("Client");

        private String value;

        private SourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourceTypeEnum value : SourceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourceTypeEnumDeserializer
    extends StdDeserializer<SourceTypeEnum> {
        public SourceTypeEnumDeserializer() {
            super(SourceTypeEnumDeserializer.class);
        }

        public SourceTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourceTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

