/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.KnowledgeBaseReference;
import com.mypurecloud.sdk.v2.model.KnowledgeBaseWithDialectReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KnowledgeSuggestionConfig
implements Serializable {
    private VendorNameEnum vendorName = null;
    private KnowledgeBaseReference knowledgeBase = null;
    private List<KnowledgeBaseWithDialectReference> knowledgeBases = null;
    private Boolean receiveSegmentedArticles = null;

    public KnowledgeSuggestionConfig() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.knowledgeBases = new ArrayList<KnowledgeBaseWithDialectReference>();
        }
    }

    public KnowledgeSuggestionConfig vendorName(VendorNameEnum vendorName) {
        this.vendorName = vendorName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of vendor used for knowledge suggestions.")
    @JsonProperty(value="vendorName")
    public VendorNameEnum getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(VendorNameEnum vendorName) {
        this.vendorName = vendorName;
    }

    public KnowledgeSuggestionConfig knowledgeBase(KnowledgeBaseReference knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of knowledge base to query when Genesys is the knowledge suggestions provider.")
    @JsonProperty(value="knowledgeBase")
    public KnowledgeBaseReference getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(KnowledgeBaseReference knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    public KnowledgeSuggestionConfig knowledgeBases(List<KnowledgeBaseWithDialectReference> knowledgeBases) {
        this.knowledgeBases = knowledgeBases;
        return this;
    }

    @ApiModelProperty(example="null", value="The knowledge bases to query based on dialect, when Genesys is the knowledge suggestions provider.")
    @JsonProperty(value="knowledgeBases")
    public List<KnowledgeBaseWithDialectReference> getKnowledgeBases() {
        return this.knowledgeBases;
    }

    public void setKnowledgeBases(List<KnowledgeBaseWithDialectReference> knowledgeBases) {
        this.knowledgeBases = knowledgeBases;
    }

    public KnowledgeSuggestionConfig receiveSegmentedArticles(Boolean receiveSegmentedArticles) {
        this.receiveSegmentedArticles = receiveSegmentedArticles;
        return this;
    }

    @ApiModelProperty(example="null", value="Include segmented articles in knowledge suggestions.")
    @JsonProperty(value="receiveSegmentedArticles")
    public Boolean getReceiveSegmentedArticles() {
        return this.receiveSegmentedArticles;
    }

    public void setReceiveSegmentedArticles(Boolean receiveSegmentedArticles) {
        this.receiveSegmentedArticles = receiveSegmentedArticles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeSuggestionConfig knowledgeSuggestionConfig = (KnowledgeSuggestionConfig)o;
        return Objects.equals((Object)this.vendorName, (Object)knowledgeSuggestionConfig.vendorName) && Objects.equals(this.knowledgeBase, knowledgeSuggestionConfig.knowledgeBase) && Objects.equals(this.knowledgeBases, knowledgeSuggestionConfig.knowledgeBases) && Objects.equals(this.receiveSegmentedArticles, knowledgeSuggestionConfig.receiveSegmentedArticles);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vendorName, this.knowledgeBase, this.knowledgeBases, this.receiveSegmentedArticles});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeSuggestionConfig {\n");
        sb.append("    vendorName: ").append(this.toIndentedString((Object)this.vendorName)).append("\n");
        sb.append("    knowledgeBase: ").append(this.toIndentedString(this.knowledgeBase)).append("\n");
        sb.append("    knowledgeBases: ").append(this.toIndentedString(this.knowledgeBases)).append("\n");
        sb.append("    receiveSegmentedArticles: ").append(this.toIndentedString(this.receiveSegmentedArticles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=VendorNameEnumDeserializer.class)
    public static enum VendorNameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GOOGLEDIALOGFLOW("GoogleDialogflow"),
        GENESYSKNOWLEDGE("GenesysKnowledge"),
        UNKNOWN("Unknown");

        private String value;

        private VendorNameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static VendorNameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (VendorNameEnum value : VendorNameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return VendorNameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class VendorNameEnumDeserializer
    extends StdDeserializer<VendorNameEnum> {
        public VendorNameEnumDeserializer() {
            super(VendorNameEnumDeserializer.class);
        }

        public VendorNameEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return VendorNameEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

