/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="The metrics of an element or a link in journey ")
public class JourneyViewResultMetrics
implements Serializable {
    private Long participantCount = null;
    private Long activeCount = null;
    private Long completedCount = null;
    private Long dropoutCount = null;
    private Long flowCount = null;

    public JourneyViewResultMetrics() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="number of external contacts who participated at the element")
    @JsonProperty(value="participantCount")
    public Long getParticipantCount() {
        return this.participantCount;
    }

    @ApiModelProperty(example="null", value="number of external contacts who could still complete the journey")
    @JsonProperty(value="activeCount")
    public Long getActiveCount() {
        return this.activeCount;
    }

    @ApiModelProperty(example="null", value="number of external contacts who completed the journey forward")
    @JsonProperty(value="completedCount")
    public Long getCompletedCount() {
        return this.completedCount;
    }

    @ApiModelProperty(example="null", value="number of external contacts who did not make it to the next element")
    @JsonProperty(value="dropoutCount")
    public Long getDropoutCount() {
        return this.dropoutCount;
    }

    @ApiModelProperty(example="null", value="number of external contacts who moved from one element to next element but did not complete the journey")
    @JsonProperty(value="flowCount")
    public Long getFlowCount() {
        return this.flowCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyViewResultMetrics journeyViewResultMetrics = (JourneyViewResultMetrics)o;
        return Objects.equals(this.participantCount, journeyViewResultMetrics.participantCount) && Objects.equals(this.activeCount, journeyViewResultMetrics.activeCount) && Objects.equals(this.completedCount, journeyViewResultMetrics.completedCount) && Objects.equals(this.dropoutCount, journeyViewResultMetrics.dropoutCount) && Objects.equals(this.flowCount, journeyViewResultMetrics.flowCount);
    }

    public int hashCode() {
        return Objects.hash(this.participantCount, this.activeCount, this.completedCount, this.dropoutCount, this.flowCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyViewResultMetrics {\n");
        sb.append("    participantCount: ").append(this.toIndentedString(this.participantCount)).append("\n");
        sb.append("    activeCount: ").append(this.toIndentedString(this.activeCount)).append("\n");
        sb.append("    completedCount: ").append(this.toIndentedString(this.completedCount)).append("\n");
        sb.append("    dropoutCount: ").append(this.toIndentedString(this.dropoutCount)).append("\n");
        sb.append("    flowCount: ").append(this.toIndentedString(this.flowCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

