/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.FlowCharacteristics;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Defines a characteristic that can be captured by data providers")
public class FlowLogLevelCharacteristicsDefinition
implements Serializable {
    private String id = null;
    private MinimumLevelEnum minimumLevel = null;
    private FlowCharacteristics dependsOn = null;

    public FlowLogLevelCharacteristicsDefinition() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The minimum level required for this characteristic to be enabled.")
    @JsonProperty(value="minimumLevel")
    public MinimumLevelEnum getMinimumLevel() {
        return this.minimumLevel;
    }

    @ApiModelProperty(example="null", value="If set, this is the id of the characteristic that this one depends on and it must be enabled for this to be enabled.")
    @JsonProperty(value="dependsOn")
    public FlowCharacteristics getDependsOn() {
        return this.dependsOn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowLogLevelCharacteristicsDefinition flowLogLevelCharacteristicsDefinition = (FlowLogLevelCharacteristicsDefinition)o;
        return Objects.equals(this.id, flowLogLevelCharacteristicsDefinition.id) && Objects.equals((Object)this.minimumLevel, (Object)flowLogLevelCharacteristicsDefinition.minimumLevel) && Objects.equals(this.dependsOn, flowLogLevelCharacteristicsDefinition.dependsOn);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.minimumLevel, this.dependsOn});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowLogLevelCharacteristicsDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    minimumLevel: ").append(this.toIndentedString((Object)this.minimumLevel)).append("\n");
        sb.append("    dependsOn: ").append(this.toIndentedString(this.dependsOn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MinimumLevelEnumDeserializer.class)
    public static enum MinimumLevelEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        DISABLED("Disabled"),
        BASE("Base"),
        NOTES("Notes"),
        VERBOSENOTES("VerboseNotes"),
        ALL("All");

        private String value;

        private MinimumLevelEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MinimumLevelEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MinimumLevelEnum value : MinimumLevelEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MinimumLevelEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MinimumLevelEnumDeserializer
    extends StdDeserializer<MinimumLevelEnum> {
        public MinimumLevelEnumDeserializer() {
            super(MinimumLevelEnumDeserializer.class);
        }

        public MinimumLevelEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MinimumLevelEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

