/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.EmailInitialConfiguration;
import com.mypurecloud.sdk.v2.model.SourceConfiguration;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class EmailExternalEstablishedEvent
implements Serializable {
    private String eventId = null;
    private Date eventDateTime = null;
    private String conversationId = null;
    private String communicationId = null;
    private String displayName = null;
    private Boolean includeMessage = null;
    private EmailInitialConfiguration initialConfiguration = null;
    private SourceConfiguration sourceConfiguration = null;

    public EmailExternalEstablishedEvent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public EmailExternalEstablishedEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique (V4 UUID) eventId for this event")
    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public EmailExternalEstablishedEvent eventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDateTime")
    public Date getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    public EmailExternalEstablishedEvent conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public EmailExternalEstablishedEvent communicationId(String communicationId) {
        this.communicationId = communicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this communication.")
    @JsonProperty(value="communicationId")
    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public EmailExternalEstablishedEvent displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", value="A name for the participant if it is available for this conversation.")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public EmailExternalEstablishedEvent includeMessage(Boolean includeMessage) {
        this.includeMessage = includeMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates that established communication has an initial email. If true, the initial messagesSent value will be initialized to 1.")
    @JsonProperty(value="includeMessage")
    public Boolean getIncludeMessage() {
        return this.includeMessage;
    }

    public void setIncludeMessage(Boolean includeMessage) {
        this.includeMessage = includeMessage;
    }

    public EmailExternalEstablishedEvent initialConfiguration(EmailInitialConfiguration initialConfiguration) {
        this.initialConfiguration = initialConfiguration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Metadata about this communication.")
    @JsonProperty(value="initialConfiguration")
    public EmailInitialConfiguration getInitialConfiguration() {
        return this.initialConfiguration;
    }

    public void setInitialConfiguration(EmailInitialConfiguration initialConfiguration) {
        this.initialConfiguration = initialConfiguration;
    }

    public EmailExternalEstablishedEvent sourceConfiguration(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Metadata about the source of this communication's interaction.")
    @JsonProperty(value="sourceConfiguration")
    public SourceConfiguration getSourceConfiguration() {
        return this.sourceConfiguration;
    }

    public void setSourceConfiguration(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailExternalEstablishedEvent emailExternalEstablishedEvent = (EmailExternalEstablishedEvent)o;
        return Objects.equals(this.eventId, emailExternalEstablishedEvent.eventId) && Objects.equals(this.eventDateTime, emailExternalEstablishedEvent.eventDateTime) && Objects.equals(this.conversationId, emailExternalEstablishedEvent.conversationId) && Objects.equals(this.communicationId, emailExternalEstablishedEvent.communicationId) && Objects.equals(this.displayName, emailExternalEstablishedEvent.displayName) && Objects.equals(this.includeMessage, emailExternalEstablishedEvent.includeMessage) && Objects.equals(this.initialConfiguration, emailExternalEstablishedEvent.initialConfiguration) && Objects.equals(this.sourceConfiguration, emailExternalEstablishedEvent.sourceConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventDateTime, this.conversationId, this.communicationId, this.displayName, this.includeMessage, this.initialConfiguration, this.sourceConfiguration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailExternalEstablishedEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventDateTime: ").append(this.toIndentedString(this.eventDateTime)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    communicationId: ").append(this.toIndentedString(this.communicationId)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    includeMessage: ").append(this.toIndentedString(this.includeMessage)).append("\n");
        sb.append("    initialConfiguration: ").append(this.toIndentedString(this.initialConfiguration)).append("\n");
        sb.append("    sourceConfiguration: ").append(this.toIndentedString(this.sourceConfiguration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

