/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Contact;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateUser
implements Serializable {
    private String name = null;
    private String department = null;
    private String email = null;
    private List<Contact> addresses = null;
    private String title = null;
    private String password = null;
    private String divisionId = null;
    private StateEnum state = null;

    public CreateUser() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.addresses = new ArrayList<Contact>();
        }
    }

    public CreateUser name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User's full name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateUser department(String department) {
        this.department = department;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="department")
    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public CreateUser email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User's email and username")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CreateUser addresses(List<Contact> addresses) {
        this.addresses = addresses;
        return this;
    }

    @ApiModelProperty(example="null", value="Email addresses and phone numbers for this user")
    @JsonProperty(value="addresses")
    public List<Contact> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Contact> addresses) {
        this.addresses = addresses;
    }

    public CreateUser title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CreateUser password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(example="null", value="User's password")
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CreateUser divisionId(String divisionId) {
        this.divisionId = divisionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The division to which this user will belong")
    @JsonProperty(value="divisionId")
    public String getDivisionId() {
        return this.divisionId;
    }

    public void setDivisionId(String divisionId) {
        this.divisionId = divisionId;
    }

    public CreateUser state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional initialized state of the user. If not specified, state will be Active if invites are sent, otherwise Inactive.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUser createUser = (CreateUser)o;
        return Objects.equals(this.name, createUser.name) && Objects.equals(this.department, createUser.department) && Objects.equals(this.email, createUser.email) && Objects.equals(this.addresses, createUser.addresses) && Objects.equals(this.title, createUser.title) && Objects.equals(this.password, createUser.password) && Objects.equals(this.divisionId, createUser.divisionId) && Objects.equals((Object)this.state, (Object)createUser.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.department, this.email, this.addresses, this.title, this.password, this.divisionId, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUser {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    department: ").append(this.toIndentedString(this.department)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    divisionId: ").append(this.toIndentedString(this.divisionId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

