/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationEnrichment;
import com.mypurecloud.sdk.v2.model.ConversationMessageContent;
import com.mypurecloud.sdk.v2.model.ConversationMessageEvent;
import com.mypurecloud.sdk.v2.model.ConversationMessagingChannel;
import com.mypurecloud.sdk.v2.model.ConversationReason;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="General rich media message structure with normalized feature support across many messaging channels.")
public class ConversationNormalizedMessage
implements Serializable {
    private String id = null;
    private ConversationMessagingChannel channel = null;
    private TypeEnum type = null;
    private String text = null;
    private List<ConversationMessageContent> content = null;
    private List<ConversationMessageEvent> events = null;
    private StatusEnum status = null;
    private List<ConversationReason> reasons = null;
    private OriginatingEntityEnum originatingEntity = null;
    private Boolean isFinalReceipt = null;
    private DirectionEnum direction = null;
    private List<ConversationNormalizedMessage> relatedMessages = null;
    private Map<String, String> metadata = null;
    private ConversationEnrichment enrichment = null;
    private String byoSmsIntegrationId = null;

    public ConversationNormalizedMessage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.content = new ArrayList<ConversationMessageContent>();
            this.events = new ArrayList<ConversationMessageEvent>();
            this.reasons = new ArrayList<ConversationReason>();
            this.relatedMessages = new ArrayList<ConversationNormalizedMessage>();
        }
    }

    @ApiModelProperty(example="null", value="Unique ID of the message. Message receipts will have the same ID as the message they reference.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="Channel-specific information that describes the message and the message channel/provider.")
    @JsonProperty(value="channel")
    public ConversationMessagingChannel getChannel() {
        return this.channel;
    }

    public ConversationNormalizedMessage type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message type.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ConversationNormalizedMessage text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Message text.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ConversationNormalizedMessage content(List<ConversationMessageContent> content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", value="List of content elements.")
    @JsonProperty(value="content")
    public List<ConversationMessageContent> getContent() {
        return this.content;
    }

    public void setContent(List<ConversationMessageContent> content) {
        this.content = content;
    }

    public ConversationNormalizedMessage events(List<ConversationMessageEvent> events) {
        this.events = events;
        return this;
    }

    @ApiModelProperty(example="null", value="List of event elements.")
    @JsonProperty(value="events")
    public List<ConversationMessageEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<ConversationMessageEvent> events) {
        this.events = events;
    }

    @ApiModelProperty(example="null", value="Message receipt status, only used with type Receipt.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.")
    @JsonProperty(value="reasons")
    public List<ConversationReason> getReasons() {
        return this.reasons;
    }

    public ConversationNormalizedMessage originatingEntity(OriginatingEntityEnum originatingEntity) {
        this.originatingEntity = originatingEntity;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies if this message was sent by a human agent or bot. The platform may use this to apply appropriate provider policies.")
    @JsonProperty(value="originatingEntity")
    public OriginatingEntityEnum getOriginatingEntity() {
        return this.originatingEntity;
    }

    public void setOriginatingEntity(OriginatingEntityEnum originatingEntity) {
        this.originatingEntity = originatingEntity;
    }

    @ApiModelProperty(example="null", value="Indicates if this is the last message receipt for this message, or if another message receipt can be expected.")
    @JsonProperty(value="isFinalReceipt")
    public Boolean getIsFinalReceipt() {
        return this.isFinalReceipt;
    }

    @ApiModelProperty(example="null", value="The direction of the message.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public ConversationNormalizedMessage relatedMessages(List<ConversationNormalizedMessage> relatedMessages) {
        this.relatedMessages = relatedMessages;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of messages related to this one.")
    @JsonProperty(value="relatedMessages")
    public List<ConversationNormalizedMessage> getRelatedMessages() {
        return this.relatedMessages;
    }

    public void setRelatedMessages(List<ConversationNormalizedMessage> relatedMessages) {
        this.relatedMessages = relatedMessages;
    }

    public ConversationNormalizedMessage metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional metadata about this message.")
    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public ConversationNormalizedMessage enrichment(ConversationEnrichment enrichment) {
        this.enrichment = enrichment;
        return this;
    }

    @ApiModelProperty(example="null", value="Metadata enrichments provided by the platform.")
    @JsonProperty(value="enrichment")
    public ConversationEnrichment getEnrichment() {
        return this.enrichment;
    }

    public void setEnrichment(ConversationEnrichment enrichment) {
        this.enrichment = enrichment;
    }

    public ConversationNormalizedMessage byoSmsIntegrationId(String byoSmsIntegrationId) {
        this.byoSmsIntegrationId = byoSmsIntegrationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The internal id representing the customer supplied sms integration message.")
    @JsonProperty(value="byoSmsIntegrationId")
    public String getByoSmsIntegrationId() {
        return this.byoSmsIntegrationId;
    }

    public void setByoSmsIntegrationId(String byoSmsIntegrationId) {
        this.byoSmsIntegrationId = byoSmsIntegrationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationNormalizedMessage conversationNormalizedMessage = (ConversationNormalizedMessage)o;
        return Objects.equals(this.id, conversationNormalizedMessage.id) && Objects.equals(this.channel, conversationNormalizedMessage.channel) && Objects.equals((Object)this.type, (Object)conversationNormalizedMessage.type) && Objects.equals(this.text, conversationNormalizedMessage.text) && Objects.equals(this.content, conversationNormalizedMessage.content) && Objects.equals(this.events, conversationNormalizedMessage.events) && Objects.equals((Object)this.status, (Object)conversationNormalizedMessage.status) && Objects.equals(this.reasons, conversationNormalizedMessage.reasons) && Objects.equals((Object)this.originatingEntity, (Object)conversationNormalizedMessage.originatingEntity) && Objects.equals(this.isFinalReceipt, conversationNormalizedMessage.isFinalReceipt) && Objects.equals((Object)this.direction, (Object)conversationNormalizedMessage.direction) && Objects.equals(this.relatedMessages, conversationNormalizedMessage.relatedMessages) && Objects.equals(this.metadata, conversationNormalizedMessage.metadata) && Objects.equals(this.enrichment, conversationNormalizedMessage.enrichment) && Objects.equals(this.byoSmsIntegrationId, conversationNormalizedMessage.byoSmsIntegrationId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.channel, this.type, this.text, this.content, this.events, this.status, this.reasons, this.originatingEntity, this.isFinalReceipt, this.direction, this.relatedMessages, this.metadata, this.enrichment, this.byoSmsIntegrationId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationNormalizedMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reasons: ").append(this.toIndentedString(this.reasons)).append("\n");
        sb.append("    originatingEntity: ").append(this.toIndentedString((Object)this.originatingEntity)).append("\n");
        sb.append("    isFinalReceipt: ").append(this.toIndentedString(this.isFinalReceipt)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    relatedMessages: ").append(this.toIndentedString(this.relatedMessages)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    enrichment: ").append(this.toIndentedString(this.enrichment)).append("\n");
        sb.append("    byoSmsIntegrationId: ").append(this.toIndentedString(this.byoSmsIntegrationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT("Text"),
        STRUCTURED("Structured"),
        RECEIPT("Receipt"),
        EVENT("Event"),
        MESSAGE("Message"),
        UNKNOWN("Unknown");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SENT("Sent"),
        DELIVERED("Delivered"),
        READ("Read"),
        FAILED("Failed"),
        PUBLISHED("Published"),
        REMOVED("Removed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OriginatingEntityEnumDeserializer.class)
    public static enum OriginatingEntityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HUMAN("Human"),
        BOT("Bot");

        private String value;

        private OriginatingEntityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OriginatingEntityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OriginatingEntityEnum value : OriginatingEntityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OriginatingEntityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("Inbound"),
        OUTBOUND("Outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OriginatingEntityEnumDeserializer
    extends StdDeserializer<OriginatingEntityEnum> {
        public OriginatingEntityEnumDeserializer() {
            super(OriginatingEntityEnumDeserializer.class);
        }

        public OriginatingEntityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OriginatingEntityEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

