/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.CobrowseMediaParticipant;
import com.mypurecloud.sdk.v2.model.ConversationDivisionMembership;
import com.mypurecloud.sdk.v2.model.TransferResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CobrowseConversation
implements Serializable {
    private String id = null;
    private String name = null;
    private List<CobrowseMediaParticipant> participants = null;
    private List<String> otherMediaUris = null;
    private List<TransferResponse> recentTransfers = null;
    private String utilizationLabelId = null;
    private Date inactivityTimeout = null;
    private List<ConversationDivisionMembership> divisions = null;
    private String selfUri = null;

    public CobrowseConversation() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.participants = new ArrayList<CobrowseMediaParticipant>();
            this.otherMediaUris = new ArrayList<String>();
            this.recentTransfers = new ArrayList<TransferResponse>();
            this.divisions = new ArrayList<ConversationDivisionMembership>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public CobrowseConversation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CobrowseConversation participants(List<CobrowseMediaParticipant> participants) {
        this.participants = participants;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of participants involved in the conversation.")
    @JsonProperty(value="participants")
    public List<CobrowseMediaParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<CobrowseMediaParticipant> participants) {
        this.participants = participants;
    }

    public CobrowseConversation otherMediaUris(List<String> otherMediaUris) {
        this.otherMediaUris = otherMediaUris;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of other media channels involved in the conversation.")
    @JsonProperty(value="otherMediaUris")
    public List<String> getOtherMediaUris() {
        return this.otherMediaUris;
    }

    public void setOtherMediaUris(List<String> otherMediaUris) {
        this.otherMediaUris = otherMediaUris;
    }

    public CobrowseConversation recentTransfers(List<TransferResponse> recentTransfers) {
        this.recentTransfers = recentTransfers;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of the most recent 20 transfer commands applied to this conversation.")
    @JsonProperty(value="recentTransfers")
    public List<TransferResponse> getRecentTransfers() {
        return this.recentTransfers;
    }

    public void setRecentTransfers(List<TransferResponse> recentTransfers) {
        this.recentTransfers = recentTransfers;
    }

    public CobrowseConversation utilizationLabelId(String utilizationLabelId) {
        this.utilizationLabelId = utilizationLabelId;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional label that categorizes the conversation.  Max-utilization settings can be configured at a per-label level")
    @JsonProperty(value="utilizationLabelId")
    public String getUtilizationLabelId() {
        return this.utilizationLabelId;
    }

    public void setUtilizationLabelId(String utilizationLabelId) {
        this.utilizationLabelId = utilizationLabelId;
    }

    public CobrowseConversation inactivityTimeout(Date inactivityTimeout) {
        this.inactivityTimeout = inactivityTimeout;
        return this;
    }

    @ApiModelProperty(example="null", value="The time in the future, after which this conversation would be considered inactive. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="inactivityTimeout")
    public Date getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public void setInactivityTimeout(Date inactivityTimeout) {
        this.inactivityTimeout = inactivityTimeout;
    }

    public CobrowseConversation divisions(List<ConversationDivisionMembership> divisions) {
        this.divisions = divisions;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifiers of divisions associated with this conversation.")
    @JsonProperty(value="divisions")
    public List<ConversationDivisionMembership> getDivisions() {
        return this.divisions;
    }

    public void setDivisions(List<ConversationDivisionMembership> divisions) {
        this.divisions = divisions;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CobrowseConversation cobrowseConversation = (CobrowseConversation)o;
        return Objects.equals(this.id, cobrowseConversation.id) && Objects.equals(this.name, cobrowseConversation.name) && Objects.equals(this.participants, cobrowseConversation.participants) && Objects.equals(this.otherMediaUris, cobrowseConversation.otherMediaUris) && Objects.equals(this.recentTransfers, cobrowseConversation.recentTransfers) && Objects.equals(this.utilizationLabelId, cobrowseConversation.utilizationLabelId) && Objects.equals(this.inactivityTimeout, cobrowseConversation.inactivityTimeout) && Objects.equals(this.divisions, cobrowseConversation.divisions) && Objects.equals(this.selfUri, cobrowseConversation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.participants, this.otherMediaUris, this.recentTransfers, this.utilizationLabelId, this.inactivityTimeout, this.divisions, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CobrowseConversation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("    otherMediaUris: ").append(this.toIndentedString(this.otherMediaUris)).append("\n");
        sb.append("    recentTransfers: ").append(this.toIndentedString(this.recentTransfers)).append("\n");
        sb.append("    utilizationLabelId: ").append(this.toIndentedString(this.utilizationLabelId)).append("\n");
        sb.append("    inactivityTimeout: ").append(this.toIndentedString(this.inactivityTimeout)).append("\n");
        sb.append("    divisions: ").append(this.toIndentedString(this.divisions)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

