/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationRoutingData;
import com.mypurecloud.sdk.v2.model.Disposition;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorInfo;
import com.mypurecloud.sdk.v2.model.FaxStatus;
import com.mypurecloud.sdk.v2.model.JourneyContext;
import com.mypurecloud.sdk.v2.model.RecordersState;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CallMediaParticipant
implements Serializable {
    private String id = null;
    private String name = null;
    private String address = null;
    private Date startTime = null;
    private Date startAlertingTime = null;
    private Date connectedTime = null;
    private Date endTime = null;
    private Date startHoldTime = null;
    private String purpose = null;
    private StateEnum state = null;
    private DirectionEnum direction = null;
    private DisconnectTypeEnum disconnectType = null;
    private Boolean held = null;
    private Boolean wrapupRequired = null;
    private String wrapupPrompt = null;
    private List<String> mediaRoles = null;
    private DomainEntityRef user = null;
    private DomainEntityRef queue = null;
    private DomainEntityRef team = null;
    private Map<String, String> attributes = null;
    private ErrorInfo errorInfo = null;
    private DomainEntityRef script = null;
    private Integer wrapupTimeoutMs = null;
    private Boolean wrapupSkipped = null;
    private Integer alertingTimeoutMs = null;
    private String provider = null;
    private DomainEntityRef externalContact = null;
    private String externalContactInitialDivisionId = null;
    private DomainEntityRef externalOrganization = null;
    private Wrapup wrapup = null;
    private String peer = null;
    private FlaggedReasonEnum flaggedReason = null;
    private JourneyContext journeyContext = null;
    private ConversationRoutingData conversationRoutingData = null;
    private Date startAcwTime = null;
    private Date endAcwTime = null;
    private Date parkTime = null;
    private Date resumeTime = null;
    private Boolean muted = null;
    private Boolean confined = null;
    private Boolean recording = null;
    private RecordingStateEnum recordingState = null;
    private RecordersState recordersState = null;
    private DomainEntityRef group = null;
    private String ani = null;
    private String dnis = null;
    private String documentId = null;
    private FaxStatus faxStatus = null;
    private String monitoredParticipantId = null;
    private String coachedParticipantId = null;
    private String bargedParticipantId = null;
    private String consultParticipantId = null;
    private String uuiData = null;
    private Date bargedTime = null;
    private Boolean securePause = null;
    private Disposition disposition = null;

    public CallMediaParticipant() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.mediaRoles = new ArrayList<String>();
        }
    }

    public CallMediaParticipant id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique participant ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CallMediaParticipant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The display friendly name of the participant.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CallMediaParticipant address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant address.")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public CallMediaParticipant startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public CallMediaParticipant startAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startAlertingTime")
    public Date getStartAlertingTime() {
        return this.startAlertingTime;
    }

    public void setStartAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
    }

    public CallMediaParticipant connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public CallMediaParticipant endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endTime")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public CallMediaParticipant startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant's hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public CallMediaParticipant purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr")
    @JsonProperty(value="purpose")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public CallMediaParticipant state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's state.  Values can be: 'alerting', 'connected', 'disconnected', 'dialing', 'contacting")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public CallMediaParticipant direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's direction.  Values can be: 'inbound' or 'outbound'")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public CallMediaParticipant disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the participant was disconnected from the conversation.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public CallMediaParticipant held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant is on hold.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public CallMediaParticipant wrapupRequired(Boolean wrapupRequired) {
        this.wrapupRequired = wrapupRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant requires wrap-up.")
    @JsonProperty(value="wrapupRequired")
    public Boolean getWrapupRequired() {
        return this.wrapupRequired;
    }

    public void setWrapupRequired(Boolean wrapupRequired) {
        this.wrapupRequired = wrapupRequired;
    }

    public CallMediaParticipant wrapupPrompt(String wrapupPrompt) {
        this.wrapupPrompt = wrapupPrompt;
        return this;
    }

    @ApiModelProperty(example="null", value="The wrap-up prompt indicating the type of wrap-up to be performed.")
    @JsonProperty(value="wrapupPrompt")
    public String getWrapupPrompt() {
        return this.wrapupPrompt;
    }

    public void setWrapupPrompt(String wrapupPrompt) {
        this.wrapupPrompt = wrapupPrompt;
    }

    public CallMediaParticipant mediaRoles(List<String> mediaRoles) {
        this.mediaRoles = mediaRoles;
        return this;
    }

    @ApiModelProperty(example="null", value="List of roles this participant's media has had on the conversation, ie monitor, coach, etc")
    @JsonProperty(value="mediaRoles")
    public List<String> getMediaRoles() {
        return this.mediaRoles;
    }

    public void setMediaRoles(List<String> mediaRoles) {
        this.mediaRoles = mediaRoles;
    }

    public CallMediaParticipant user(DomainEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud user for this participant.")
    @JsonProperty(value="user")
    public DomainEntityRef getUser() {
        return this.user;
    }

    public void setUser(DomainEntityRef user) {
        this.user = user;
    }

    public CallMediaParticipant queue(DomainEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud queue for this participant.")
    @JsonProperty(value="queue")
    public DomainEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(DomainEntityRef queue) {
        this.queue = queue;
    }

    public CallMediaParticipant team(DomainEntityRef team) {
        this.team = team;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud team for this participant.")
    @JsonProperty(value="team")
    public DomainEntityRef getTeam() {
        return this.team;
    }

    public void setTeam(DomainEntityRef team) {
        this.team = team;
    }

    public CallMediaParticipant attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of ad-hoc attributes for the participant.")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public CallMediaParticipant errorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="If the conversation ends in error, contains additional error details.")
    @JsonProperty(value="errorInfo")
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public CallMediaParticipant script(DomainEntityRef script) {
        this.script = script;
        return this;
    }

    @ApiModelProperty(example="null", value="The Engage script that should be used by this participant.")
    @JsonProperty(value="script")
    public DomainEntityRef getScript() {
        return this.script;
    }

    public void setScript(DomainEntityRef script) {
        this.script = script;
    }

    public CallMediaParticipant wrapupTimeoutMs(Integer wrapupTimeoutMs) {
        this.wrapupTimeoutMs = wrapupTimeoutMs;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time the participant has to complete wrap-up.")
    @JsonProperty(value="wrapupTimeoutMs")
    public Integer getWrapupTimeoutMs() {
        return this.wrapupTimeoutMs;
    }

    public void setWrapupTimeoutMs(Integer wrapupTimeoutMs) {
        this.wrapupTimeoutMs = wrapupTimeoutMs;
    }

    public CallMediaParticipant wrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant has skipped wrap-up.")
    @JsonProperty(value="wrapupSkipped")
    public Boolean getWrapupSkipped() {
        return this.wrapupSkipped;
    }

    public void setWrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
    }

    public CallMediaParticipant alertingTimeoutMs(Integer alertingTimeoutMs) {
        this.alertingTimeoutMs = alertingTimeoutMs;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies how long the agent has to answer an interaction before being marked as not responding.")
    @JsonProperty(value="alertingTimeoutMs")
    public Integer getAlertingTimeoutMs() {
        return this.alertingTimeoutMs;
    }

    public void setAlertingTimeoutMs(Integer alertingTimeoutMs) {
        this.alertingTimeoutMs = alertingTimeoutMs;
    }

    public CallMediaParticipant provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the communication.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public CallMediaParticipant externalContact(DomainEntityRef externalContact) {
        this.externalContact = externalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external contact, then this will be the reference for the external contact.")
    @JsonProperty(value="externalContact")
    public DomainEntityRef getExternalContact() {
        return this.externalContact;
    }

    public void setExternalContact(DomainEntityRef externalContact) {
        this.externalContact = externalContact;
    }

    public CallMediaParticipant externalContactInitialDivisionId(String externalContactInitialDivisionId) {
        this.externalContactInitialDivisionId = externalContactInitialDivisionId;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external contact, then this will be the initial division for the external contact. This value will not be updated if the external contact is reassigned.")
    @JsonProperty(value="externalContactInitialDivisionId")
    public String getExternalContactInitialDivisionId() {
        return this.externalContactInitialDivisionId;
    }

    public void setExternalContactInitialDivisionId(String externalContactInitialDivisionId) {
        this.externalContactInitialDivisionId = externalContactInitialDivisionId;
    }

    public CallMediaParticipant externalOrganization(DomainEntityRef externalOrganization) {
        this.externalOrganization = externalOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external org, then this will be the reference for the external org.")
    @JsonProperty(value="externalOrganization")
    public DomainEntityRef getExternalOrganization() {
        return this.externalOrganization;
    }

    public void setExternalOrganization(DomainEntityRef externalOrganization) {
        this.externalOrganization = externalOrganization;
    }

    public CallMediaParticipant wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Wrapup for this participant, if it has been applied.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public CallMediaParticipant peer(String peer) {
        this.peer = peer;
        return this;
    }

    @ApiModelProperty(example="null", value="The peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peer")
    public String getPeer() {
        return this.peer;
    }

    public void setPeer(String peer) {
        this.peer = peer;
    }

    public CallMediaParticipant flaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason specifying why participant flagged the conversation.")
    @JsonProperty(value="flaggedReason")
    public FlaggedReasonEnum getFlaggedReason() {
        return this.flaggedReason;
    }

    public void setFlaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
    }

    public CallMediaParticipant journeyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Journey System data/context that is applicable to this communication.  When used for historical purposes, the context should be immutable.  When null, there is no applicable Journey System context.")
    @JsonProperty(value="journeyContext")
    public JourneyContext getJourneyContext() {
        return this.journeyContext;
    }

    public void setJourneyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
    }

    public CallMediaParticipant conversationRoutingData(ConversationRoutingData conversationRoutingData) {
        this.conversationRoutingData = conversationRoutingData;
        return this;
    }

    @ApiModelProperty(example="null", value="Information on how a communication should be routed to an agent.")
    @JsonProperty(value="conversationRoutingData")
    public ConversationRoutingData getConversationRoutingData() {
        return this.conversationRoutingData;
    }

    public void setConversationRoutingData(ConversationRoutingData conversationRoutingData) {
        this.conversationRoutingData = conversationRoutingData;
    }

    public CallMediaParticipant startAcwTime(Date startAcwTime) {
        this.startAcwTime = startAcwTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant started after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startAcwTime")
    public Date getStartAcwTime() {
        return this.startAcwTime;
    }

    public void setStartAcwTime(Date startAcwTime) {
        this.startAcwTime = startAcwTime;
    }

    public CallMediaParticipant endAcwTime(Date endAcwTime) {
        this.endAcwTime = endAcwTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant ended after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endAcwTime")
    public Date getEndAcwTime() {
        return this.endAcwTime;
    }

    public void setEndAcwTime(Date endAcwTime) {
        this.endAcwTime = endAcwTime;
    }

    public CallMediaParticipant parkTime(Date parkTime) {
        this.parkTime = parkTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant's communication was last parked.  Does not reset on resume. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="parkTime")
    public Date getParkTime() {
        return this.parkTime;
    }

    public void setParkTime(Date parkTime) {
        this.parkTime = parkTime;
    }

    public CallMediaParticipant resumeTime(Date resumeTime) {
        this.resumeTime = resumeTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant's communications will resume. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="resumeTime")
    public Date getResumeTime() {
        return this.resumeTime;
    }

    public void setResumeTime(Date resumeTime) {
        this.resumeTime = resumeTime;
    }

    public CallMediaParticipant muted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the call is muted.")
    @JsonProperty(value="muted")
    public Boolean getMuted() {
        return this.muted;
    }

    public void setMuted(Boolean muted) {
        this.muted = muted;
    }

    public CallMediaParticipant confined(Boolean confined) {
        this.confined = confined;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the call is confined.")
    @JsonProperty(value="confined")
    public Boolean getConfined() {
        return this.confined;
    }

    public void setConfined(Boolean confined) {
        this.confined = confined;
    }

    public CallMediaParticipant recording(Boolean recording) {
        this.recording = recording;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the call is being recorded.")
    @JsonProperty(value="recording")
    public Boolean getRecording() {
        return this.recording;
    }

    public void setRecording(Boolean recording) {
        this.recording = recording;
    }

    public CallMediaParticipant recordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the call recording.")
    @JsonProperty(value="recordingState")
    public RecordingStateEnum getRecordingState() {
        return this.recordingState;
    }

    public void setRecordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
    }

    public CallMediaParticipant recordersState(RecordersState recordersState) {
        this.recordersState = recordersState;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains the states of different recorders.")
    @JsonProperty(value="recordersState")
    public RecordersState getRecordersState() {
        return this.recordersState;
    }

    public void setRecordersState(RecordersState recordersState) {
        this.recordersState = recordersState;
    }

    public CallMediaParticipant group(DomainEntityRef group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(example="null", value="The group involved in the group ring call.")
    @JsonProperty(value="group")
    public DomainEntityRef getGroup() {
        return this.group;
    }

    public void setGroup(DomainEntityRef group) {
        this.group = group;
    }

    public CallMediaParticipant ani(String ani) {
        this.ani = ani;
        return this;
    }

    @ApiModelProperty(example="null", value="The call ANI.")
    @JsonProperty(value="ani")
    public String getAni() {
        return this.ani;
    }

    public void setAni(String ani) {
        this.ani = ani;
    }

    public CallMediaParticipant dnis(String dnis) {
        this.dnis = dnis;
        return this;
    }

    @ApiModelProperty(example="null", value="The call DNIS.")
    @JsonProperty(value="dnis")
    public String getDnis() {
        return this.dnis;
    }

    public void setDnis(String dnis) {
        this.dnis = dnis;
    }

    public CallMediaParticipant documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the Content Management document if the call is a fax.")
    @JsonProperty(value="documentId")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public CallMediaParticipant faxStatus(FaxStatus faxStatus) {
        this.faxStatus = faxStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Extra fax information if the call is a fax.")
    @JsonProperty(value="faxStatus")
    public FaxStatus getFaxStatus() {
        return this.faxStatus;
    }

    public void setFaxStatus(FaxStatus faxStatus) {
        this.faxStatus = faxStatus;
    }

    public CallMediaParticipant monitoredParticipantId(String monitoredParticipantId) {
        this.monitoredParticipantId = monitoredParticipantId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the participant being monitored when performing a call monitor.")
    @JsonProperty(value="monitoredParticipantId")
    public String getMonitoredParticipantId() {
        return this.monitoredParticipantId;
    }

    public void setMonitoredParticipantId(String monitoredParticipantId) {
        this.monitoredParticipantId = monitoredParticipantId;
    }

    public CallMediaParticipant coachedParticipantId(String coachedParticipantId) {
        this.coachedParticipantId = coachedParticipantId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the participant being coached when performing a call coach.")
    @JsonProperty(value="coachedParticipantId")
    public String getCoachedParticipantId() {
        return this.coachedParticipantId;
    }

    public void setCoachedParticipantId(String coachedParticipantId) {
        this.coachedParticipantId = coachedParticipantId;
    }

    public CallMediaParticipant bargedParticipantId(String bargedParticipantId) {
        this.bargedParticipantId = bargedParticipantId;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant barged in a participant's call, then this will be the id of the targeted participant.")
    @JsonProperty(value="bargedParticipantId")
    public String getBargedParticipantId() {
        return this.bargedParticipantId;
    }

    public void setBargedParticipantId(String bargedParticipantId) {
        this.bargedParticipantId = bargedParticipantId;
    }

    public CallMediaParticipant consultParticipantId(String consultParticipantId) {
        this.consultParticipantId = consultParticipantId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the consult transfer target participant when performing a consult transfer.")
    @JsonProperty(value="consultParticipantId")
    public String getConsultParticipantId() {
        return this.consultParticipantId;
    }

    public void setConsultParticipantId(String consultParticipantId) {
        this.consultParticipantId = consultParticipantId;
    }

    public CallMediaParticipant uuiData(String uuiData) {
        this.uuiData = uuiData;
        return this;
    }

    @ApiModelProperty(example="null", value="User-to-User information which maps to a SIP header field defined in RFC7433. UUI data is used in the Public Switched Telephone Network (PSTN) for use cases described in RFC6567.")
    @JsonProperty(value="uuiData")
    public String getUuiData() {
        return this.uuiData;
    }

    public void setUuiData(String uuiData) {
        this.uuiData = uuiData;
    }

    public CallMediaParticipant bargedTime(Date bargedTime) {
        this.bargedTime = bargedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant was connected to the barge conference in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="bargedTime")
    public Date getBargedTime() {
        return this.bargedTime;
    }

    public void setBargedTime(Date bargedTime) {
        this.bargedTime = bargedTime;
    }

    public CallMediaParticipant securePause(Boolean securePause) {
        this.securePause = securePause;
        return this;
    }

    @ApiModelProperty(example="null", value="True when the recording of this call is in secure pause status.")
    @JsonProperty(value="securePause")
    public Boolean getSecurePause() {
        return this.securePause;
    }

    public void setSecurePause(Boolean securePause) {
        this.securePause = securePause;
    }

    public CallMediaParticipant disposition(Disposition disposition) {
        this.disposition = disposition;
        return this;
    }

    @ApiModelProperty(example="null", value="Call resolution data for Dialer bulk make calls commands.")
    @JsonProperty(value="disposition")
    public Disposition getDisposition() {
        return this.disposition;
    }

    public void setDisposition(Disposition disposition) {
        this.disposition = disposition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallMediaParticipant callMediaParticipant = (CallMediaParticipant)o;
        return Objects.equals(this.id, callMediaParticipant.id) && Objects.equals(this.name, callMediaParticipant.name) && Objects.equals(this.address, callMediaParticipant.address) && Objects.equals(this.startTime, callMediaParticipant.startTime) && Objects.equals(this.startAlertingTime, callMediaParticipant.startAlertingTime) && Objects.equals(this.connectedTime, callMediaParticipant.connectedTime) && Objects.equals(this.endTime, callMediaParticipant.endTime) && Objects.equals(this.startHoldTime, callMediaParticipant.startHoldTime) && Objects.equals(this.purpose, callMediaParticipant.purpose) && Objects.equals((Object)this.state, (Object)callMediaParticipant.state) && Objects.equals((Object)this.direction, (Object)callMediaParticipant.direction) && Objects.equals((Object)this.disconnectType, (Object)callMediaParticipant.disconnectType) && Objects.equals(this.held, callMediaParticipant.held) && Objects.equals(this.wrapupRequired, callMediaParticipant.wrapupRequired) && Objects.equals(this.wrapupPrompt, callMediaParticipant.wrapupPrompt) && Objects.equals(this.mediaRoles, callMediaParticipant.mediaRoles) && Objects.equals(this.user, callMediaParticipant.user) && Objects.equals(this.queue, callMediaParticipant.queue) && Objects.equals(this.team, callMediaParticipant.team) && Objects.equals(this.attributes, callMediaParticipant.attributes) && Objects.equals(this.errorInfo, callMediaParticipant.errorInfo) && Objects.equals(this.script, callMediaParticipant.script) && Objects.equals(this.wrapupTimeoutMs, callMediaParticipant.wrapupTimeoutMs) && Objects.equals(this.wrapupSkipped, callMediaParticipant.wrapupSkipped) && Objects.equals(this.alertingTimeoutMs, callMediaParticipant.alertingTimeoutMs) && Objects.equals(this.provider, callMediaParticipant.provider) && Objects.equals(this.externalContact, callMediaParticipant.externalContact) && Objects.equals(this.externalContactInitialDivisionId, callMediaParticipant.externalContactInitialDivisionId) && Objects.equals(this.externalOrganization, callMediaParticipant.externalOrganization) && Objects.equals(this.wrapup, callMediaParticipant.wrapup) && Objects.equals(this.peer, callMediaParticipant.peer) && Objects.equals((Object)this.flaggedReason, (Object)callMediaParticipant.flaggedReason) && Objects.equals(this.journeyContext, callMediaParticipant.journeyContext) && Objects.equals(this.conversationRoutingData, callMediaParticipant.conversationRoutingData) && Objects.equals(this.startAcwTime, callMediaParticipant.startAcwTime) && Objects.equals(this.endAcwTime, callMediaParticipant.endAcwTime) && Objects.equals(this.parkTime, callMediaParticipant.parkTime) && Objects.equals(this.resumeTime, callMediaParticipant.resumeTime) && Objects.equals(this.muted, callMediaParticipant.muted) && Objects.equals(this.confined, callMediaParticipant.confined) && Objects.equals(this.recording, callMediaParticipant.recording) && Objects.equals((Object)this.recordingState, (Object)callMediaParticipant.recordingState) && Objects.equals(this.recordersState, callMediaParticipant.recordersState) && Objects.equals(this.group, callMediaParticipant.group) && Objects.equals(this.ani, callMediaParticipant.ani) && Objects.equals(this.dnis, callMediaParticipant.dnis) && Objects.equals(this.documentId, callMediaParticipant.documentId) && Objects.equals(this.faxStatus, callMediaParticipant.faxStatus) && Objects.equals(this.monitoredParticipantId, callMediaParticipant.monitoredParticipantId) && Objects.equals(this.coachedParticipantId, callMediaParticipant.coachedParticipantId) && Objects.equals(this.bargedParticipantId, callMediaParticipant.bargedParticipantId) && Objects.equals(this.consultParticipantId, callMediaParticipant.consultParticipantId) && Objects.equals(this.uuiData, callMediaParticipant.uuiData) && Objects.equals(this.bargedTime, callMediaParticipant.bargedTime) && Objects.equals(this.securePause, callMediaParticipant.securePause) && Objects.equals(this.disposition, callMediaParticipant.disposition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.address, this.startTime, this.startAlertingTime, this.connectedTime, this.endTime, this.startHoldTime, this.purpose, this.state, this.direction, this.disconnectType, this.held, this.wrapupRequired, this.wrapupPrompt, this.mediaRoles, this.user, this.queue, this.team, this.attributes, this.errorInfo, this.script, this.wrapupTimeoutMs, this.wrapupSkipped, this.alertingTimeoutMs, this.provider, this.externalContact, this.externalContactInitialDivisionId, this.externalOrganization, this.wrapup, this.peer, this.flaggedReason, this.journeyContext, this.conversationRoutingData, this.startAcwTime, this.endAcwTime, this.parkTime, this.resumeTime, this.muted, this.confined, this.recording, this.recordingState, this.recordersState, this.group, this.ani, this.dnis, this.documentId, this.faxStatus, this.monitoredParticipantId, this.coachedParticipantId, this.bargedParticipantId, this.consultParticipantId, this.uuiData, this.bargedTime, this.securePause, this.disposition});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallMediaParticipant {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    startAlertingTime: ").append(this.toIndentedString(this.startAlertingTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    wrapupRequired: ").append(this.toIndentedString(this.wrapupRequired)).append("\n");
        sb.append("    wrapupPrompt: ").append(this.toIndentedString(this.wrapupPrompt)).append("\n");
        sb.append("    mediaRoles: ").append(this.toIndentedString(this.mediaRoles)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    team: ").append(this.toIndentedString(this.team)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    script: ").append(this.toIndentedString(this.script)).append("\n");
        sb.append("    wrapupTimeoutMs: ").append(this.toIndentedString(this.wrapupTimeoutMs)).append("\n");
        sb.append("    wrapupSkipped: ").append(this.toIndentedString(this.wrapupSkipped)).append("\n");
        sb.append("    alertingTimeoutMs: ").append(this.toIndentedString(this.alertingTimeoutMs)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    externalContactInitialDivisionId: ").append(this.toIndentedString(this.externalContactInitialDivisionId)).append("\n");
        sb.append("    externalOrganization: ").append(this.toIndentedString(this.externalOrganization)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    peer: ").append(this.toIndentedString(this.peer)).append("\n");
        sb.append("    flaggedReason: ").append(this.toIndentedString((Object)this.flaggedReason)).append("\n");
        sb.append("    journeyContext: ").append(this.toIndentedString(this.journeyContext)).append("\n");
        sb.append("    conversationRoutingData: ").append(this.toIndentedString(this.conversationRoutingData)).append("\n");
        sb.append("    startAcwTime: ").append(this.toIndentedString(this.startAcwTime)).append("\n");
        sb.append("    endAcwTime: ").append(this.toIndentedString(this.endAcwTime)).append("\n");
        sb.append("    parkTime: ").append(this.toIndentedString(this.parkTime)).append("\n");
        sb.append("    resumeTime: ").append(this.toIndentedString(this.resumeTime)).append("\n");
        sb.append("    muted: ").append(this.toIndentedString(this.muted)).append("\n");
        sb.append("    confined: ").append(this.toIndentedString(this.confined)).append("\n");
        sb.append("    recording: ").append(this.toIndentedString(this.recording)).append("\n");
        sb.append("    recordingState: ").append(this.toIndentedString((Object)this.recordingState)).append("\n");
        sb.append("    recordersState: ").append(this.toIndentedString(this.recordersState)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    ani: ").append(this.toIndentedString(this.ani)).append("\n");
        sb.append("    dnis: ").append(this.toIndentedString(this.dnis)).append("\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    faxStatus: ").append(this.toIndentedString(this.faxStatus)).append("\n");
        sb.append("    monitoredParticipantId: ").append(this.toIndentedString(this.monitoredParticipantId)).append("\n");
        sb.append("    coachedParticipantId: ").append(this.toIndentedString(this.coachedParticipantId)).append("\n");
        sb.append("    bargedParticipantId: ").append(this.toIndentedString(this.bargedParticipantId)).append("\n");
        sb.append("    consultParticipantId: ").append(this.toIndentedString(this.consultParticipantId)).append("\n");
        sb.append("    uuiData: ").append(this.toIndentedString(this.uuiData)).append("\n");
        sb.append("    bargedTime: ").append(this.toIndentedString(this.bargedTime)).append("\n");
        sb.append("    securePause: ").append(this.toIndentedString(this.securePause)).append("\n");
        sb.append("    disposition: ").append(this.toIndentedString(this.disposition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        CONVERTING("converting"),
        UPLOADING("uploading"),
        TRANSMITTING("transmitting"),
        PARKED("parked"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DisconnectTypeEnumDeserializer.class)
    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        ENDPOINT_DONOTDISTURB("endpoint.donotdisturb"),
        CLIENT("client"),
        SYSTEM("system"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_DONOTDISTURB("transfer.donotdisturb"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam"),
        INACTIVITY("inactivity"),
        SESSION_EXPIRED("session.expired");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=FlaggedReasonEnumDeserializer.class)
    public static enum FlaggedReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENERAL("general");

        private String value;

        private FlaggedReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlaggedReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlaggedReasonEnum value : FlaggedReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlaggedReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=RecordingStateEnumDeserializer.class)
    public static enum RecordingStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("none"),
        ACTIVE("active"),
        PAUSED("paused");

        private String value;

        private RecordingStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RecordingStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RecordingStateEnum value : RecordingStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RecordingStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RecordingStateEnumDeserializer
    extends StdDeserializer<RecordingStateEnum> {
        public RecordingStateEnumDeserializer() {
            super(RecordingStateEnumDeserializer.class);
        }

        public RecordingStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RecordingStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class FlaggedReasonEnumDeserializer
    extends StdDeserializer<FlaggedReasonEnum> {
        public FlaggedReasonEnumDeserializer() {
            super(FlaggedReasonEnumDeserializer.class);
        }

        public FlaggedReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlaggedReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DisconnectTypeEnumDeserializer
    extends StdDeserializer<DisconnectTypeEnum> {
        public DisconnectTypeEnumDeserializer() {
            super(DisconnectTypeEnumDeserializer.class);
        }

        public DisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

