/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class PushDeviceInsertRequest
implements Serializable {
    private String deviceToken = null;
    private NotificationProviderEnum notificationProvider = null;
    private String language = null;
    private DeviceTypeEnum deviceType = null;

    public PushDeviceInsertRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public PushDeviceInsertRequest deviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The device token generated by the network providers")
    @JsonProperty(value="deviceToken")
    public String getDeviceToken() {
        return this.deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public PushDeviceInsertRequest notificationProvider(NotificationProviderEnum notificationProvider) {
        this.notificationProvider = notificationProvider;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The notification provider for the device (FCM / APNS)")
    @JsonProperty(value="notificationProvider")
    public NotificationProviderEnum getNotificationProvider() {
        return this.notificationProvider;
    }

    public void setNotificationProvider(NotificationProviderEnum notificationProvider) {
        this.notificationProvider = notificationProvider;
    }

    public PushDeviceInsertRequest language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The preferred language of the user (eg. en-us, de, fr)")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public PushDeviceInsertRequest deviceType(DeviceTypeEnum deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the device (Android / IoS)")
    @JsonProperty(value="deviceType")
    public DeviceTypeEnum getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceTypeEnum deviceType) {
        this.deviceType = deviceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushDeviceInsertRequest pushDeviceInsertRequest = (PushDeviceInsertRequest)o;
        return Objects.equals(this.deviceToken, pushDeviceInsertRequest.deviceToken) && Objects.equals((Object)this.notificationProvider, (Object)pushDeviceInsertRequest.notificationProvider) && Objects.equals(this.language, pushDeviceInsertRequest.language) && Objects.equals((Object)this.deviceType, (Object)pushDeviceInsertRequest.deviceType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceToken, this.notificationProvider, this.language, this.deviceType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PushDeviceInsertRequest {\n");
        sb.append("    deviceToken: ").append(this.toIndentedString(this.deviceToken)).append("\n");
        sb.append("    notificationProvider: ").append(this.toIndentedString((Object)this.notificationProvider)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    deviceType: ").append(this.toIndentedString((Object)this.deviceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=NotificationProviderEnumDeserializer.class)
    public static enum NotificationProviderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FCM("FCM"),
        APNS("APNS");

        private String value;

        private NotificationProviderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NotificationProviderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NotificationProviderEnum value : NotificationProviderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NotificationProviderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DeviceTypeEnumDeserializer.class)
    public static enum DeviceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ANDROID("android"),
        IOS("ios");

        private String value;

        private DeviceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DeviceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DeviceTypeEnum value : DeviceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DeviceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DeviceTypeEnumDeserializer
    extends StdDeserializer<DeviceTypeEnum> {
        public DeviceTypeEnumDeserializer() {
            super(DeviceTypeEnumDeserializer.class);
        }

        public DeviceTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DeviceTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class NotificationProviderEnumDeserializer
    extends StdDeserializer<NotificationProviderEnum> {
        public NotificationProviderEnumDeserializer() {
            super(NotificationProviderEnumDeserializer.class);
        }

        public NotificationProviderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NotificationProviderEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

