/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AmazonLexRequest;
import com.mypurecloud.sdk.v2.model.GenesysBotConnector;
import com.mypurecloud.sdk.v2.model.GoogleDialogflowCustomSettings;
import com.mypurecloud.sdk.v2.model.NuanceMixDlgSettings;
import com.mypurecloud.sdk.v2.model.PostTextMessage;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PostTextRequest
implements Serializable {
    private String botId = null;
    private String botAlias = null;
    private String integrationId = null;
    private String botSessionId = null;
    private PostTextMessage postTextMessage = null;
    private String languageCode = null;
    private Integer botSessionTimeoutMinutes = null;
    private List<BotChannelsEnum> botChannels = null;
    private String botCorrelationId = null;
    private MessagingPlatformTypeEnum messagingPlatformType = null;
    private AmazonLexRequest amazonLexRequest = null;
    private GoogleDialogflowCustomSettings googleDialogflow = null;
    private GenesysBotConnector genesysBotConnector = null;
    private NuanceMixDlgSettings nuanceMixDlg = null;

    public PostTextRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.botChannels = new ArrayList<BotChannelsEnum>();
        }
    }

    public PostTextRequest botId(String botId) {
        this.botId = botId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the bot to send the text to.")
    @JsonProperty(value="botId")
    public String getBotId() {
        return this.botId;
    }

    public void setBotId(String botId) {
        this.botId = botId;
    }

    public PostTextRequest botAlias(String botAlias) {
        this.botAlias = botAlias;
        return this;
    }

    @ApiModelProperty(example="null", value="Alias/Version of the bot")
    @JsonProperty(value="botAlias")
    public String getBotAlias() {
        return this.botAlias;
    }

    public void setBotAlias(String botAlias) {
        this.botAlias = botAlias;
    }

    public PostTextRequest integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="the integration service id for the bot's credentials")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public PostTextRequest botSessionId(String botSessionId) {
        this.botSessionId = botSessionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="GUID for this bot's session")
    @JsonProperty(value="botSessionId")
    public String getBotSessionId() {
        return this.botSessionId;
    }

    public void setBotSessionId(String botSessionId) {
        this.botSessionId = botSessionId;
    }

    public PostTextRequest postTextMessage(PostTextMessage postTextMessage) {
        this.postTextMessage = postTextMessage;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message to send to the bot")
    @JsonProperty(value="postTextMessage")
    public PostTextMessage getPostTextMessage() {
        return this.postTextMessage;
    }

    public void setPostTextMessage(PostTextMessage postTextMessage) {
        this.postTextMessage = postTextMessage;
    }

    public PostTextRequest languageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The language code the bot will run under")
    @JsonProperty(value="languageCode")
    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public PostTextRequest botSessionTimeoutMinutes(Integer botSessionTimeoutMinutes) {
        this.botSessionTimeoutMinutes = botSessionTimeoutMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Override timeout for the bot session. This should be greater than 10 minutes.")
    @JsonProperty(value="botSessionTimeoutMinutes")
    public Integer getBotSessionTimeoutMinutes() {
        return this.botSessionTimeoutMinutes;
    }

    public void setBotSessionTimeoutMinutes(Integer botSessionTimeoutMinutes) {
        this.botSessionTimeoutMinutes = botSessionTimeoutMinutes;
    }

    public PostTextRequest botChannels(List<BotChannelsEnum> botChannels) {
        this.botChannels = botChannels;
        return this;
    }

    @ApiModelProperty(example="null", value="The channels this bot is utilizing")
    @JsonProperty(value="botChannels")
    public List<BotChannelsEnum> getBotChannels() {
        return this.botChannels;
    }

    public void setBotChannels(List<BotChannelsEnum> botChannels) {
        this.botChannels = botChannels;
    }

    public PostTextRequest botCorrelationId(String botCorrelationId) {
        this.botCorrelationId = botCorrelationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Id for tracking the activity - this will be returned in the response")
    @JsonProperty(value="botCorrelationId")
    public String getBotCorrelationId() {
        return this.botCorrelationId;
    }

    public void setBotCorrelationId(String botCorrelationId) {
        this.botCorrelationId = botCorrelationId;
    }

    public PostTextRequest messagingPlatformType(MessagingPlatformTypeEnum messagingPlatformType) {
        this.messagingPlatformType = messagingPlatformType;
        return this;
    }

    @ApiModelProperty(example="null", value="If the channels list contains a 'Messaging' item and the messaging platform is known, include it here to get accurate analytics")
    @JsonProperty(value="messagingPlatformType")
    public MessagingPlatformTypeEnum getMessagingPlatformType() {
        return this.messagingPlatformType;
    }

    public void setMessagingPlatformType(MessagingPlatformTypeEnum messagingPlatformType) {
        this.messagingPlatformType = messagingPlatformType;
    }

    public PostTextRequest amazonLexRequest(AmazonLexRequest amazonLexRequest) {
        this.amazonLexRequest = amazonLexRequest;
        return this;
    }

    @ApiModelProperty(example="null", value="Provider specific settings, if any")
    @JsonProperty(value="amazonLexRequest")
    public AmazonLexRequest getAmazonLexRequest() {
        return this.amazonLexRequest;
    }

    public void setAmazonLexRequest(AmazonLexRequest amazonLexRequest) {
        this.amazonLexRequest = amazonLexRequest;
    }

    public PostTextRequest googleDialogflow(GoogleDialogflowCustomSettings googleDialogflow) {
        this.googleDialogflow = googleDialogflow;
        return this;
    }

    @ApiModelProperty(example="null", value="Provider specific settings, if any")
    @JsonProperty(value="googleDialogflow")
    public GoogleDialogflowCustomSettings getGoogleDialogflow() {
        return this.googleDialogflow;
    }

    public void setGoogleDialogflow(GoogleDialogflowCustomSettings googleDialogflow) {
        this.googleDialogflow = googleDialogflow;
    }

    public PostTextRequest genesysBotConnector(GenesysBotConnector genesysBotConnector) {
        this.genesysBotConnector = genesysBotConnector;
        return this;
    }

    @ApiModelProperty(example="null", value="Provider specific settings, if any")
    @JsonProperty(value="genesysBotConnector")
    public GenesysBotConnector getGenesysBotConnector() {
        return this.genesysBotConnector;
    }

    public void setGenesysBotConnector(GenesysBotConnector genesysBotConnector) {
        this.genesysBotConnector = genesysBotConnector;
    }

    public PostTextRequest nuanceMixDlg(NuanceMixDlgSettings nuanceMixDlg) {
        this.nuanceMixDlg = nuanceMixDlg;
        return this;
    }

    @ApiModelProperty(example="null", value="Provider specific settings, if any")
    @JsonProperty(value="nuanceMixDlg")
    public NuanceMixDlgSettings getNuanceMixDlg() {
        return this.nuanceMixDlg;
    }

    public void setNuanceMixDlg(NuanceMixDlgSettings nuanceMixDlg) {
        this.nuanceMixDlg = nuanceMixDlg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTextRequest postTextRequest = (PostTextRequest)o;
        return Objects.equals(this.botId, postTextRequest.botId) && Objects.equals(this.botAlias, postTextRequest.botAlias) && Objects.equals(this.integrationId, postTextRequest.integrationId) && Objects.equals(this.botSessionId, postTextRequest.botSessionId) && Objects.equals(this.postTextMessage, postTextRequest.postTextMessage) && Objects.equals(this.languageCode, postTextRequest.languageCode) && Objects.equals(this.botSessionTimeoutMinutes, postTextRequest.botSessionTimeoutMinutes) && Objects.equals(this.botChannels, postTextRequest.botChannels) && Objects.equals(this.botCorrelationId, postTextRequest.botCorrelationId) && Objects.equals((Object)this.messagingPlatformType, (Object)postTextRequest.messagingPlatformType) && Objects.equals(this.amazonLexRequest, postTextRequest.amazonLexRequest) && Objects.equals(this.googleDialogflow, postTextRequest.googleDialogflow) && Objects.equals(this.genesysBotConnector, postTextRequest.genesysBotConnector) && Objects.equals(this.nuanceMixDlg, postTextRequest.nuanceMixDlg);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.botId, this.botAlias, this.integrationId, this.botSessionId, this.postTextMessage, this.languageCode, this.botSessionTimeoutMinutes, this.botChannels, this.botCorrelationId, this.messagingPlatformType, this.amazonLexRequest, this.googleDialogflow, this.genesysBotConnector, this.nuanceMixDlg});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostTextRequest {\n");
        sb.append("    botId: ").append(this.toIndentedString(this.botId)).append("\n");
        sb.append("    botAlias: ").append(this.toIndentedString(this.botAlias)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    botSessionId: ").append(this.toIndentedString(this.botSessionId)).append("\n");
        sb.append("    postTextMessage: ").append(this.toIndentedString(this.postTextMessage)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString(this.languageCode)).append("\n");
        sb.append("    botSessionTimeoutMinutes: ").append(this.toIndentedString(this.botSessionTimeoutMinutes)).append("\n");
        sb.append("    botChannels: ").append(this.toIndentedString(this.botChannels)).append("\n");
        sb.append("    botCorrelationId: ").append(this.toIndentedString(this.botCorrelationId)).append("\n");
        sb.append("    messagingPlatformType: ").append(this.toIndentedString((Object)this.messagingPlatformType)).append("\n");
        sb.append("    amazonLexRequest: ").append(this.toIndentedString(this.amazonLexRequest)).append("\n");
        sb.append("    googleDialogflow: ").append(this.toIndentedString(this.googleDialogflow)).append("\n");
        sb.append("    genesysBotConnector: ").append(this.toIndentedString(this.genesysBotConnector)).append("\n");
        sb.append("    nuanceMixDlg: ").append(this.toIndentedString(this.nuanceMixDlg)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MessagingPlatformTypeEnumDeserializer.class)
    public static enum MessagingPlatformTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PHONE("Phone"),
        SMS("SMS"),
        GENESYSWEBWIDGET("GenesysWebWidget"),
        FACEBOOKMESSENGER("FacebookMessenger"),
        WECHAT("WeChat"),
        WHATSAPP("Whatsapp"),
        APPLEBUSINESSCHAT("AppleBusinessChat"),
        APPLE("Apple"),
        TELEGRAM("Telegram"),
        SLACK("Slack"),
        SIGNAL("Signal"),
        LINE("Line"),
        DISCORD("Discord"),
        TWITTERDIRECTMESSAGE("TwitterDirectMessage"),
        OPEN("Open"),
        INSTAGRAM("Instagram"),
        OTHER("Other"),
        UNKNOWN("Unknown");

        private String value;

        private MessagingPlatformTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessagingPlatformTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessagingPlatformTypeEnum value : MessagingPlatformTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessagingPlatformTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MessagingPlatformTypeEnumDeserializer
    extends StdDeserializer<MessagingPlatformTypeEnum> {
        public MessagingPlatformTypeEnumDeserializer() {
            super(MessagingPlatformTypeEnumDeserializer.class);
        }

        public MessagingPlatformTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MessagingPlatformTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=BotChannelsEnumDeserializer.class)
    public static enum BotChannelsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("Call"),
        CALLBACK("Callback"),
        MESSAGING("Messaging"),
        WEBCHAT("Webchat");

        private String value;

        private BotChannelsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BotChannelsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BotChannelsEnum value : BotChannelsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BotChannelsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BotChannelsEnumDeserializer
    extends StdDeserializer<BotChannelsEnum> {
        public BotChannelsEnumDeserializer() {
            super(BotChannelsEnumDeserializer.class);
        }

        public BotChannelsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return BotChannelsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

